% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_MWA.R
\name{pv}
\alias{pv}
\title{Proportion of vegetation or fractional vegetation cover}
\usage{
pv(NDVI, minNDVI, maxNDVI)
}
\arguments{
\item{NDVI}{Raster* object, NDVI calculated from remote sensing imagery}

\item{minNDVI}{= 0.2 (Ref. Sobrino et al. 2004)}

\item{maxNDVI}{= 0.5 (Ref. Sobrino et al. 2004)}
}
\value{
RasterLayer
}
\description{
Calculation of the proportion of vegetation or fractional vegetation cover from NDVI
}
\examples{
NDVI <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(NDVI) = runif(10000, min=0.02, max=0.8)
pv(NDVI = NDVI, minNDVI = 0.2, maxNDVI = 0.5)
}
