% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeModels.R
\name{TreeModels}
\alias{TreeModels}
\title{Tree-based Model Training}
\usage{
TreeModels(
  traindata = NULL,
  seed = 2022,
  methodlist = c("dt", "rf", "gbm"),
  iternumber = 10,
  dt.gridsearch = NULL,
  rf.gridsearch = NULL,
  gbm.gridsearch = NULL,
  checkprogress = FALSE
)
}
\arguments{
\item{traindata}{A \code{data.frame} with the training data set. Please name the outcome variable as "perf".}

\item{seed}{A numeric value for set.seed. It is set to be 2022 by default.}

\item{methodlist}{A list of the tree-based methods to model. The default is methodlist = c("dt", "rf", "gbm").}

\item{iternumber}{Number of resampling iterations/Number of folds for the  cross-validation scheme.}

\item{dt.gridsearch}{A \code{data.frame} of the tuning grid,  which allows for specifying parameters for decision tree model.}

\item{rf.gridsearch}{A \code{data.frame} of the tuning grid,  which allows for specifying parameters for random forest model.}

\item{gbm.gridsearch}{A \code{data.frame} of the tuning grid,  which allows for specifying parameters for gradient boosting model.}

\item{checkprogress}{Logical. Print the modeling progress if it is TRUE. The default is FALSE.}
}
\value{
This function returns two lists:

ModelObject An object with results from selected models

SummaryReport A \code{data.frame} with the summary of model parameters. The summary report is shown automatically in the output.
}
\description{
Tree-based Model Training
}
\details{
This function performs the modeling step of a predictive analysis. The selected classifiers are used for modeling the provided training dataset under a cross-validation scheme. Users have the possibility to choose which model they want to compare by specifying it on the \code{methodlist} argument. The caretEnsemble package is used in the modeling process to ensure that all models follow the same resampling procedures. ROC is used to select the optimal model for each tree-based method using the largest value. Finally, a summary report is displayed.
}
\examples{
\donttest{
colnames(training)[14] <- "perf"
ensemblist <- TreeModels(traindata = training,
methodlist = c("rf","gbm","dt"),checkprogress = TRUE)

ensemblist <- TreeModels(traindata = training,
methodlist = c("rf"),
rf.gridsearch = data.frame(mtry = 2, splitrule = "gini", min.node.size = 1))
}
}
