% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMMstar.options.R
\name{LMMstar.options}
\alias{LMMstar.options}
\title{Global options for LMMstar package}
\usage{
LMMstar.options(..., reinitialise = FALSE)
}
\arguments{
\item{...}{options to be selected or updated}

\item{reinitialise}{should all the global parameters be set to their default value}
}
\value{
A list containing the default options.
}
\description{
Update or select global options for the LMMstar package.
}
\details{
The options are: \itemize{
\item backtransform.confint [logical]: should variance/covariance/correlation estimates be back-transformed when they are transformed on the log or atanh scale. Used by \code{confint}.
\item columns.anova [character vector]: columns to ouput when using \code{anova} with argument \code{ci=TRUE}.
\item columns.confint [character vector]: columns to ouput when using \code{confint}.
\item columns.summary [character vector]: columns to ouput when displaying the model coefficients using \code{summary}.
\item df [logical]: should approximate degrees of freedom be computed for Wald and F-tests. Used by \code{lmm}, \code{anova}, \code{predict}, and \code{confint}.
\item drop.X [logical]: should columns causing non-identifiability of the model coefficients be dropped from the design matrix. Used by \code{lmm}.
\item effects [character]: parameters relative to which estimates, score, information should be output.
\item min.df [integer]: minimum possible degree of freedom. Used by \code{confint}.
\item method.fit [character]: objective function when fitting the Linear Mixed Model (REML or ML). Used by \code{lmm}.
\item method.numDeriv [character]: type used to approximate the third derivative of the log-likelihood (when computing the degrees of freedom). Can be \code{"simple"} or \code{"Richardson"}. See \code{numDeriv::jacobian} for more details. Used by \code{lmm}.
\item n.sampleCopula [integer]: number of samples used to compute confidence intervals and p-values adjusted for multiple comparisons via \code{"single-step2"}. Used by \code{confint.Wald_lmm}.
\item optimizer [character]: method used to estimate the model parameters: can the \code{nlme::gls} (\code{"gls"}) or an algorithm combine fisher scoring for the variance parameters and generalized least squares for the mean parameters (\code{"FS"}).
\item param.optimizer [numeric vector]: default option for the \code{FS} optimization routine: maximum number of gradient descent iterations (\code{n.iter}), maximum acceptable score value (\code{tol.score}), maximum acceptable change in parameter value (\code{tol.param}).
\item precompute.moments [logical]: Should the cross terms between the residuals and design matrix be pre-computed. Useful when the number of subject is substantially larger than the number of mean paramters.
\item trace [logical]: Should the progress of the execution of the \code{lmm} function be displayed?
\item tranform.sigma, tranform.k, tranform.rho: transformation used to compute the confidence intervals/p-values for the variance and correlation parameters. See the detail section of the coef function for more information.
Used by \code{lmm}, \code{anova} and \code{confint}.
\item type.information [character]: Should the expected or observed information (\code{"expected"} or \code{"observed"}) be used to perform statistical inference? Used by \code{lmm}, \code{anova} and \code{confint}.
}
}
