% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSysEval.R
\name{AQSysEval}
\alias{AQSysEval}
\title{AQSysEval}
\usage{
AQSysEval(dataSET, xmax = 30, NP = 100, TLSlope = -1.846924,
  modelName = "merchuk", convrgnceLines = FALSE, nTL = 3,
  nPoints = 3, tol = 1e-05, xlbl = "", ylbl = "",
  seriesNames = NULL, save = FALSE, HR = FALSE, autoname = FALSE,
  wdir = NULL, silent = FALSE)
}
\arguments{
\item{dataSET}{- Binodal Experimental data that will be used in the nonlinear fit}

\item{xmax}{Maximum value for the Horizontal axis' value (bottom-rich component). [type:double]}

\item{NP}{Number of points used to build the fitted curve. Default is 100. [type:Integer]}

\item{TLSlope}{The method assumes all tielines for a given ATPS are parallel, thus only one slope is required. [type:double]}

\item{modelName}{Character String specifying the nonlinear empirical equation to fit data.
The default method uses Merchuk's equation. Other mathematical descriptors can be listed using AQSysList(). [type:string]}

\item{convrgnceLines}{Magnify Plot's text to be compatible with High Resolution size [type:Logical]}

\item{nTL}{Number of tielines plotted for a given ATPS. Default is 3. [type:Integer]}

\item{nPoints}{Number of points chosen for a given tieline. Default is 3. [type:Integer]}

\item{tol}{limit of tolerance to reach to assume convergence. Default is 1e-5. [type:Integer]}

\item{xlbl}{Plot's Horizontal axis label.}

\item{ylbl}{Plot's Vertical axis label.}

\item{seriesNames}{Number of points used to build the fitted curve. Default is 100. [type:Integer]}

\item{save}{Save the generated plot in the disk using path and filename provided by the user. Default is FALSE. [type:Logical]}

\item{HR}{Magnify Plot's text to be compatible with High Resolution size [type:Logical]}

\item{autoname}{Number of points used to build the fitted curve. Default is FALSE. [type:Logical]}

\item{wdir}{The directory in which the plot file will be saved. [type:String]}

\item{silent}{save plot file without actually showing it to the user. Default is FALSE. [type:Logical]}
}
\description{
Import DB data from an Excel Worksheet.
}
\examples{
\dontrun{
AQSysDB("C:/data.xls", ColDis = "xy", CAS = FALSE)
}
}
