% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLM_robust_utils.R
\name{call_llm_robust}
\alias{call_llm_robust}
\title{Robustly Call LLM API (Simple Retry)}
\usage{
call_llm_robust(
  config,
  messages,
  tries = 5,
  wait_seconds = 10,
  backoff_factor = 5,
  verbose = FALSE,
  json = FALSE,
  memoize = FALSE
)
}
\arguments{
\item{config}{An \code{llm_config} object from \code{\link{llm_config}}.}

\item{messages}{A list of message objects (or character vector for embeddings).}

\item{tries}{Integer. Number of retries before giving up. Default is 5.}

\item{wait_seconds}{Numeric. Initial wait time (seconds) before the first retry. Default is 10.}

\item{backoff_factor}{Numeric. Multiplier for wait time after each failure. Default is 5.}

\item{verbose}{Logical. If TRUE, prints the full API response.}

\item{json}{Logical. If TRUE, returns the raw JSON as an attribute.}

\item{memoize}{Logical. If TRUE, calls are cached to avoid repeated identical requests. Default is FALSE.}
}
\value{
The successful result from \code{\link{call_llm}}, or an error if all retries fail.
}
\description{
Wraps \code{\link{call_llm}} to handle rate-limit errors (HTTP 429 or related
"Too Many Requests" messages). It retries the call a specified number of times,
using exponential backoff. You can also choose to cache responses if you do
not need fresh results each time.
}
\examples{
\dontrun{
  # Basic usage:
  robust_resp <- call_llm_robust(
    config = my_llm_config,
    messages = list(list(role = "user", content = "Hello, LLM!")),
    tries = 5,
    wait_seconds = 10,
    memoize = FALSE
  )
  cat("Response:", robust_resp, "\n")
}
}
