% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_code_agent.R
\name{build_code_agent}
\alias{build_code_agent}
\title{Build an R Code Generation Agent}
\arguments{
\item{llm}{A function that accepts a character prompt and returns an LLM response.}

\item{system_prompt}{Optional system-level instructions for the agent's behavior.}

\item{user_input}{The user's task/query (e.g., "Write function to filter NAs").}

\item{max_tries}{Maximum number of attempts for LLM calls (default: 3).}

\item{backoff}{Seconds to wait between retries (default: 2).}

\item{verbose}{Logical controlling progress messages (default: TRUE).}
}
\value{
A list containing:
\itemize{
  \item input - The user's original query
  \item llm_response - The processed LLM response
  \item system_prompt - The system instructions used
  \item success - Logical indicating if call succeeded
  \item attempts - Number of tries made
}
}
\description{
Constructs an LLM-based agent for generating, debugging, explaining, or
optimizing R code using structured prompts. The agent handles retries and
provides comprehensive code assistance.
}
\examples{
\dontrun{
agent <- build_code_agent(
  llm = call_llm,
  user_input = "Write function to remove NA rows from dataframe",
  verbose = FALSE
)
}
}
