% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dij.R
\name{dij}
\alias{dij}
\title{Calculate the Inter-site Distance}
\usage{
dij(X, i, j, q = 1)
}
\arguments{
\item{X}{A matrix object. In general, \code{X} stands for the design matrix.}

\item{i}{A positive integer, which stands for the ith row of \code{X}.}

\item{j}{A positive integer, which stands for the jth row of \code{X}. Both \code{i} and \code{j} should be in [1,nrow(X)] and they should not be equal to each other.}

\item{q}{The default is set to be 1, and it could be either 1 or 2. If \code{q} is 1, \code{dij} is the Manhattan (rectangular) distance. If \code{q} is 2, \code{dij} is the Euclidean distance.}
}
\value{
If all inputs are logical, then the output will be a positive number indicating the distance. \code{dij =  \\left\\{ \\sum_{k=1}^{m} \\vert x_{ik}-x_{jk}\\vert ^q \\right\\}^{1/q}}
}
\description{
\code{dij} returns the inter-site distance of two design points of an LHD
}
\examples{
#create a toy LHD with 5 rows and 3 columns
toy=rLHD(n=5,k=3);toy

#Calculate the inter-site distance of the 2nd and the 4th row of toy (with default q)
dij(X=toy,i=2,j=4)

#Calculate the inter-site distance of the 2nd and the 4th row of toy (with q=2)
dij(X=toy,i=2,j=4,q=2)
}
