/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.freesearch.korean;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import kr.pe.freesearch.korean.HangulException;

public class KoHangul {
    static final int MAX_KEYSTROKE_SIZE = 100;
    static final int HANGUL_SYLLABLE_START = 44032;
    static final int HANGUL_SYLLABLE_END = 55203;
    static final char DIVIDER = '\uff5c';
    static final char ASCII_DIVIDER = '|';
    static final int KO_HANGUL_SUCCESS = 1;
    static final int KO_HANGUL_ERROR = -1;
    static final int KO_HANGUL_NOT_ENOUGH_SPACE = -2;
    static final int KO_HANGUL_CONTAIN_ASCII = -3;
    static final int KO_HANGUL_NOT_CONVERTIBLE = -4;
    static final int JAMO_LEN_PER_SYLLABLE = 3;
    private static final HashMap<Character, String> codeKeyMap_ = new HashMap<Character, String>(){
        {
            this.put(Character.valueOf('\u3131'), "r");
            this.put(Character.valueOf('\u3132'), "R");
            this.put(Character.valueOf('\u3133'), "rt");
            this.put(Character.valueOf('\u3134'), "s");
            this.put(Character.valueOf('\u3135'), "sw");
            this.put(Character.valueOf('\u3136'), "sg");
            this.put(Character.valueOf('\u3137'), "e");
            this.put(Character.valueOf('\u3138'), "E");
            this.put(Character.valueOf('\u3139'), "f");
            this.put(Character.valueOf('\u313a'), "fr");
            this.put(Character.valueOf('\u313b'), "fa");
            this.put(Character.valueOf('\u313c'), "fq");
            this.put(Character.valueOf('\u313d'), "ft");
            this.put(Character.valueOf('\u313e'), "fx");
            this.put(Character.valueOf('\u313f'), "fv");
            this.put(Character.valueOf('\u3140'), "fg");
            this.put(Character.valueOf('\u3141'), "a");
            this.put(Character.valueOf('\u3142'), "q");
            this.put(Character.valueOf('\u3143'), "Q");
            this.put(Character.valueOf('\u3144'), "qt");
            this.put(Character.valueOf('\u3145'), "t");
            this.put(Character.valueOf('\u3146'), "T");
            this.put(Character.valueOf('\u3147'), "d");
            this.put(Character.valueOf('\u3148'), "w");
            this.put(Character.valueOf('\u3149'), "W");
            this.put(Character.valueOf('\u314a'), "c");
            this.put(Character.valueOf('\u314b'), "z");
            this.put(Character.valueOf('\u314c'), "x");
            this.put(Character.valueOf('\u314d'), "v");
            this.put(Character.valueOf('\u314e'), "g");
            this.put(Character.valueOf('\u314f'), "k");
            this.put(Character.valueOf('\u3150'), "o");
            this.put(Character.valueOf('\u3151'), "i");
            this.put(Character.valueOf('\u3152'), "O");
            this.put(Character.valueOf('\u3153'), "j");
            this.put(Character.valueOf('\u3154'), "p");
            this.put(Character.valueOf('\u3155'), "u");
            this.put(Character.valueOf('\u3156'), "P");
            this.put(Character.valueOf('\u3157'), "h");
            this.put(Character.valueOf('\u3158'), "hk");
            this.put(Character.valueOf('\u3159'), "ho");
            this.put(Character.valueOf('\u315a'), "hl");
            this.put(Character.valueOf('\u315b'), "y");
            this.put(Character.valueOf('\u315c'), "n");
            this.put(Character.valueOf('\u315d'), "nj");
            this.put(Character.valueOf('\u315e'), "np");
            this.put(Character.valueOf('\u315f'), "nl");
            this.put(Character.valueOf('\u3160'), "b");
            this.put(Character.valueOf('\u3161'), "m");
            this.put(Character.valueOf('\u3162'), "ml");
            this.put(Character.valueOf('\u3163'), "l");
            this.put(Character.valueOf('\u0000'), "");
        }
    };
    private static final HashMap<String, Character> keyCodeMap_ = new HashMap<String, Character>(){
        {
            this.put("r", Character.valueOf('\u3131'));
            this.put("R", Character.valueOf('\u3132'));
            this.put("rt", Character.valueOf('\u3133'));
            this.put("s", Character.valueOf('\u3134'));
            this.put("sw", Character.valueOf('\u3135'));
            this.put("sg", Character.valueOf('\u3136'));
            this.put("e", Character.valueOf('\u3137'));
            this.put("E", Character.valueOf('\u3138'));
            this.put("f", Character.valueOf('\u3139'));
            this.put("fr", Character.valueOf('\u313a'));
            this.put("fa", Character.valueOf('\u313b'));
            this.put("fq", Character.valueOf('\u313c'));
            this.put("ft", Character.valueOf('\u313d'));
            this.put("fx", Character.valueOf('\u313e'));
            this.put("fv", Character.valueOf('\u313f'));
            this.put("fg", Character.valueOf('\u3140'));
            this.put("a", Character.valueOf('\u3141'));
            this.put("q", Character.valueOf('\u3142'));
            this.put("Q", Character.valueOf('\u3143'));
            this.put("qt", Character.valueOf('\u3144'));
            this.put("t", Character.valueOf('\u3145'));
            this.put("T", Character.valueOf('\u3146'));
            this.put("d", Character.valueOf('\u3147'));
            this.put("w", Character.valueOf('\u3148'));
            this.put("W", Character.valueOf('\u3149'));
            this.put("c", Character.valueOf('\u314a'));
            this.put("z", Character.valueOf('\u314b'));
            this.put("x", Character.valueOf('\u314c'));
            this.put("v", Character.valueOf('\u314d'));
            this.put("g", Character.valueOf('\u314e'));
            this.put("k", Character.valueOf('\u314f'));
            this.put("o", Character.valueOf('\u3150'));
            this.put("i", Character.valueOf('\u3151'));
            this.put("O", Character.valueOf('\u3152'));
            this.put("j", Character.valueOf('\u3153'));
            this.put("p", Character.valueOf('\u3154'));
            this.put("u", Character.valueOf('\u3155'));
            this.put("P", Character.valueOf('\u3156'));
            this.put("h", Character.valueOf('\u3157'));
            this.put("hk", Character.valueOf('\u3158'));
            this.put("ho", Character.valueOf('\u3159'));
            this.put("hl", Character.valueOf('\u315a'));
            this.put("y", Character.valueOf('\u315b'));
            this.put("n", Character.valueOf('\u315c'));
            this.put("nj", Character.valueOf('\u315d'));
            this.put("np", Character.valueOf('\u315e'));
            this.put("nl", Character.valueOf('\u315f'));
            this.put("b", Character.valueOf('\u3160'));
            this.put("m", Character.valueOf('\u3161'));
            this.put("ml", Character.valueOf('\u3162'));
            this.put("l", Character.valueOf('\u3163'));
            this.put("", Character.valueOf('\u0000'));
        }
    };
    private static final HashMap<String, Character> multiJamoCodeMap_ = new HashMap<String, Character>(){
        {
            this.put("\u3131\u3145", Character.valueOf('\u3133'));
            this.put("\u3134\u3148", Character.valueOf('\u3135'));
            this.put("\u3134\u314e", Character.valueOf('\u3136'));
            this.put("\u3139\u3131", Character.valueOf('\u313a'));
            this.put("\u3139\u3141", Character.valueOf('\u313b'));
            this.put("\u3139\u3142", Character.valueOf('\u313c'));
            this.put("\u3139\u3145", Character.valueOf('\u313d'));
            this.put("\u3139\u314c", Character.valueOf('\u313e'));
            this.put("\u3139\u314d", Character.valueOf('\u313f'));
            this.put("\u3139\u314e", Character.valueOf('\u3140'));
            this.put("\u3142\u3145", Character.valueOf('\u3144'));
            this.put("\u3157\u314f", Character.valueOf('\u3158'));
            this.put("\u3157\u3150", Character.valueOf('\u3159'));
            this.put("\u3157\u3163", Character.valueOf('\u315a'));
            this.put("\u315c\u3153", Character.valueOf('\u315d'));
            this.put("\u315c\u3154", Character.valueOf('\u315e'));
            this.put("\u315c\u3163", Character.valueOf('\u315f'));
            this.put("\u3161\u3163", Character.valueOf('\u3162'));
            this.put("", Character.valueOf('\u0000'));
        }
    };
    private static final Character[] chosung_ = new Character[]{Character.valueOf('\u3131'), Character.valueOf('\u3132'), Character.valueOf('\u3134'), Character.valueOf('\u3137'), Character.valueOf('\u3138'), Character.valueOf('\u3139'), Character.valueOf('\u3141'), Character.valueOf('\u3142'), Character.valueOf('\u3143'), Character.valueOf('\u3145'), Character.valueOf('\u3146'), Character.valueOf('\u3147'), Character.valueOf('\u3148'), Character.valueOf('\u3149'), Character.valueOf('\u314a'), Character.valueOf('\u314b'), Character.valueOf('\u314c'), Character.valueOf('\u314d'), Character.valueOf('\u314e')};
    private static final HashMap<Character, Integer> chosungIdx_ = new HashMap<Character, Integer>(){
        {
            this.put(Character.valueOf('\u3131'), 0);
            this.put(Character.valueOf('\u3132'), 1);
            this.put(Character.valueOf('\u3134'), 2);
            this.put(Character.valueOf('\u3137'), 3);
            this.put(Character.valueOf('\u3138'), 4);
            this.put(Character.valueOf('\u3139'), 5);
            this.put(Character.valueOf('\u3141'), 6);
            this.put(Character.valueOf('\u3142'), 7);
            this.put(Character.valueOf('\u3143'), 8);
            this.put(Character.valueOf('\u3145'), 9);
            this.put(Character.valueOf('\u3146'), 10);
            this.put(Character.valueOf('\u3147'), 11);
            this.put(Character.valueOf('\u3148'), 12);
            this.put(Character.valueOf('\u3149'), 13);
            this.put(Character.valueOf('\u314a'), 14);
            this.put(Character.valueOf('\u314b'), 15);
            this.put(Character.valueOf('\u314c'), 16);
            this.put(Character.valueOf('\u314d'), 17);
            this.put(Character.valueOf('\u314e'), 18);
        }
    };
    private static final Character[] jwungsung_ = new Character[]{Character.valueOf('\u314f'), Character.valueOf('\u3150'), Character.valueOf('\u3151'), Character.valueOf('\u3152'), Character.valueOf('\u3153'), Character.valueOf('\u3154'), Character.valueOf('\u3155'), Character.valueOf('\u3156'), Character.valueOf('\u3157'), Character.valueOf('\u3158'), Character.valueOf('\u3159'), Character.valueOf('\u315a'), Character.valueOf('\u315b'), Character.valueOf('\u315c'), Character.valueOf('\u315d'), Character.valueOf('\u315e'), Character.valueOf('\u315f'), Character.valueOf('\u3160'), Character.valueOf('\u3161'), Character.valueOf('\u3162'), Character.valueOf('\u3163')};
    private static final HashMap<Character, Integer> jwungsungIdx_ = new HashMap<Character, Integer>(){
        {
            this.put(Character.valueOf('\u314f'), 0);
            this.put(Character.valueOf('\u3150'), 1);
            this.put(Character.valueOf('\u3151'), 2);
            this.put(Character.valueOf('\u3152'), 3);
            this.put(Character.valueOf('\u3153'), 4);
            this.put(Character.valueOf('\u3154'), 5);
            this.put(Character.valueOf('\u3155'), 6);
            this.put(Character.valueOf('\u3156'), 7);
            this.put(Character.valueOf('\u3157'), 8);
            this.put(Character.valueOf('\u3158'), 9);
            this.put(Character.valueOf('\u3159'), 10);
            this.put(Character.valueOf('\u315a'), 11);
            this.put(Character.valueOf('\u315b'), 12);
            this.put(Character.valueOf('\u315c'), 13);
            this.put(Character.valueOf('\u315d'), 14);
            this.put(Character.valueOf('\u315e'), 15);
            this.put(Character.valueOf('\u315f'), 16);
            this.put(Character.valueOf('\u3160'), 17);
            this.put(Character.valueOf('\u3161'), 18);
            this.put(Character.valueOf('\u3162'), 19);
            this.put(Character.valueOf('\u3163'), 20);
        }
    };
    private static final Character[] jongsung_ = new Character[]{Character.valueOf('\u0000'), Character.valueOf('\u3131'), Character.valueOf('\u3132'), Character.valueOf('\u3133'), Character.valueOf('\u3134'), Character.valueOf('\u3135'), Character.valueOf('\u3136'), Character.valueOf('\u3137'), Character.valueOf('\u3139'), Character.valueOf('\u313a'), Character.valueOf('\u313b'), Character.valueOf('\u313c'), Character.valueOf('\u313d'), Character.valueOf('\u313e'), Character.valueOf('\u313f'), Character.valueOf('\u3140'), Character.valueOf('\u3141'), Character.valueOf('\u3142'), Character.valueOf('\u3144'), Character.valueOf('\u3145'), Character.valueOf('\u3146'), Character.valueOf('\u3147'), Character.valueOf('\u3148'), Character.valueOf('\u314a'), Character.valueOf('\u314b'), Character.valueOf('\u314c'), Character.valueOf('\u314d'), Character.valueOf('\u314e')};
    private static final HashMap<Character, Integer> jongsungIdx_ = new HashMap<Character, Integer>(){
        {
            this.put(Character.valueOf('\u0000'), 0);
            this.put(Character.valueOf('\u3131'), 1);
            this.put(Character.valueOf('\u3132'), 2);
            this.put(Character.valueOf('\u3133'), 3);
            this.put(Character.valueOf('\u3134'), 4);
            this.put(Character.valueOf('\u3135'), 5);
            this.put(Character.valueOf('\u3136'), 6);
            this.put(Character.valueOf('\u3137'), 7);
            this.put(Character.valueOf('\u3139'), 8);
            this.put(Character.valueOf('\u313a'), 9);
            this.put(Character.valueOf('\u313b'), 10);
            this.put(Character.valueOf('\u313c'), 11);
            this.put(Character.valueOf('\u313d'), 12);
            this.put(Character.valueOf('\u313e'), 13);
            this.put(Character.valueOf('\u313f'), 14);
            this.put(Character.valueOf('\u3140'), 15);
            this.put(Character.valueOf('\u3141'), 16);
            this.put(Character.valueOf('\u3142'), 17);
            this.put(Character.valueOf('\u3144'), 18);
            this.put(Character.valueOf('\u3145'), 19);
            this.put(Character.valueOf('\u3146'), 20);
            this.put(Character.valueOf('\u3147'), 21);
            this.put(Character.valueOf('\u3148'), 22);
            this.put(Character.valueOf('\u314a'), 23);
            this.put(Character.valueOf('\u314b'), 24);
            this.put(Character.valueOf('\u314c'), 25);
            this.put(Character.valueOf('\u314d'), 26);
            this.put(Character.valueOf('\u314e'), 27);
        }
    };
    private static final HashSet<Character> jaeum_ = new HashSet<Character>(Arrays.asList(Character.valueOf('\u3131'), Character.valueOf('\u3132'), Character.valueOf('\u3133'), Character.valueOf('\u3134'), Character.valueOf('\u3135'), Character.valueOf('\u3136'), Character.valueOf('\u3137'), Character.valueOf('\u3138'), Character.valueOf('\u3139'), Character.valueOf('\u313a'), Character.valueOf('\u313b'), Character.valueOf('\u313c'), Character.valueOf('\u313d'), Character.valueOf('\u313e'), Character.valueOf('\u313f'), Character.valueOf('\u3140'), Character.valueOf('\u3141'), Character.valueOf('\u3142'), Character.valueOf('\u3143'), Character.valueOf('\u3144'), Character.valueOf('\u3145'), Character.valueOf('\u3146'), Character.valueOf('\u3147'), Character.valueOf('\u3148'), Character.valueOf('\u3149'), Character.valueOf('\u314a'), Character.valueOf('\u314b'), Character.valueOf('\u314c'), Character.valueOf('\u314d'), Character.valueOf('\u314e')));
    private static final HashSet<Character> moeum_ = new HashSet<Character>(Arrays.asList(jwungsung_));

    public static boolean isHangul(char ch) {
        return '\uac00' <= ch && ch <= '\ud7a3' || KoHangul.isJamo(ch);
    }

    public static boolean isHangulString(String str) {
        if (str.length() == 0) {
            return false;
        }
        char[] strchar = str.toCharArray();
        int i = 0;
        while (i < strchar.length) {
            if (!KoHangul.isHangul(strchar[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isJamo(char ch) {
        return KoHangul.isJaeum(ch) || KoHangul.isMoeum(ch);
    }

    public static boolean isJamoString(String str) {
        if (str.length() == 0) {
            return false;
        }
        char[] strchar = str.toCharArray();
        int i = 0;
        while (i < strchar.length) {
            if (!KoHangul.isJamo(strchar[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static char convertHalfwidthToFullwidth(char ch) {
        return (char)(ch - 65 + 65313);
    }

    private KoHangul() {
    }

    public static boolean isInCodeKey(char code) {
        return codeKeyMap_.containsKey(Character.valueOf(code));
    }

    public static boolean isInKeyCode(String key) {
        return keyCodeMap_.containsKey(key);
    }

    public static char getCodefromKey(String key) {
        return keyCodeMap_.get(key).charValue();
    }

    public static boolean isInMultiJamo(String jamos) {
        return multiJamoCodeMap_.containsKey(jamos);
    }

    public static char getMultiJamo(String jamos) {
        return multiJamoCodeMap_.get(jamos).charValue();
    }

    public static String getKeyfromCode(char code) {
        return codeKeyMap_.get(Character.valueOf(code));
    }

    public static boolean isJaeum(char ch) {
        return jaeum_.contains(Character.valueOf(ch));
    }

    public static boolean isJaeumString(String str) {
        if (str.length() == 0) {
            return false;
        }
        char[] strchar = str.toCharArray();
        int i = 0;
        while (i < strchar.length) {
            if (!KoHangul.isJaeum(strchar[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiString(String str) {
        if (str.length() == 0) {
            return false;
        }
        char[] strchar = str.toCharArray();
        int i = 0;
        while (i < strchar.length) {
            if (!KoHangul.isAscii(strchar[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isMoeum(char ch) {
        return moeum_.contains(Character.valueOf(ch));
    }

    public static boolean isMoeumString(String str) {
        if (str.length() == 0) {
            return false;
        }
        char[] strchar = str.toCharArray();
        int i = 0;
        while (i < strchar.length) {
            if (!KoHangul.isMoeum(strchar[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Integer getChosungIdx(char ch) {
        return chosungIdx_.get(Character.valueOf(ch));
    }

    public static Integer getJwungsungIdx(char ch) {
        return jwungsungIdx_.get(Character.valueOf(ch));
    }

    public static Integer getJongsungIdx(char ch) {
        return jongsungIdx_.get(Character.valueOf(ch));
    }

    public static char convertJamosToHangulSyllable(char[] jamos) {
        if (jamos.length != 3) {
            return '\u0000';
        }
        if (jamos[0] == '\u0000' || jamos[1] == '\u0000') {
            return jamos[0] != '\u0000' ? jamos[0] : jamos[1];
        }
        return (char)(44032 + KoHangul.getChosungIdx(jamos[0]) * 588 + KoHangul.getJwungsungIdx(jamos[1]) * 28 + KoHangul.getJongsungIdx(jamos[2]));
    }

    protected static final char[] convertHangulSyllableToJamo(char syllable) {
        char[] jamos = new char[3];
        if (KoHangul.isJaeum(syllable)) {
            jamos[0] = syllable;
            return jamos;
        }
        if (KoHangul.isMoeum(syllable)) {
            jamos[1] = syllable;
            return jamos;
        }
        int jamoBuf3 = syllable - 44032;
        int jamoBuf1 = jamoBuf3 / 588;
        int jamoBuf2 = (jamoBuf3 %= 588) / 28;
        jamos[0] = chosung_[jamoBuf1].charValue();
        jamos[1] = jwungsung_[jamoBuf2].charValue();
        jamos[2] = jongsung_[jamoBuf3 %= 28].charValue();
        return jamos;
    }

    protected static final String convertHangulStringToJamos(String hangul, boolean div) throws HangulException {
        StringBuffer sb = new StringBuffer(hangul.length() * 6);
        int i = 0;
        while (i < hangul.length()) {
            if (!KoHangul.isHangul(hangul.charAt(i))) {
                sb.append(hangul.charAt(i));
            } else {
                char[] jamo = KoHangul.convertHangulSyllableToJamo(hangul.charAt(i));
                assert (jamo.length == 3);
                int j = 0;
                while (j < jamo.length) {
                    if (jamo[j] != '\u0000') {
                        sb.append(jamo[j]);
                    }
                    ++j;
                }
            }
            if (div) {
                sb.append('\uff5c');
            }
            ++i;
        }
        return new String(sb).trim();
    }

    protected static final String convertHangulStringToKeyStrokes(String origSyllables, boolean isFullwidth, boolean div) {
        char[] keystrokes = new char[origSyllables.length() * 6];
        int keyIdx = 0;
        int i = 0;
        while (i < origSyllables.length()) {
            if (KoHangul.isHangul(origSyllables.charAt(i))) {
                char[] jamos;
                char[] cArray = jamos = KoHangul.convertHangulSyllableToJamo(origSyllables.charAt(i));
                int n = jamos.length;
                int n2 = 0;
                while (n2 < n) {
                    char jamo = cArray[n2];
                    char[] keys = KoHangul.getKeyfromCode(jamo).toCharArray();
                    char[] fwKeys = new char[keys.length];
                    int j = 0;
                    while (j < keys.length) {
                        fwKeys[j] = isFullwidth ? KoHangul.convertHalfwidthToFullwidth(keys[j]) : keys[j];
                        ++j;
                    }
                    System.arraycopy(fwKeys, 0, keystrokes, keyIdx, fwKeys.length);
                    keyIdx += fwKeys.length;
                    ++n2;
                }
            } else {
                keystrokes[keyIdx++] = origSyllables.charAt(i);
            }
            if (div) {
                keystrokes[keyIdx++] = 65372;
            }
            ++i;
        }
        return new String(keystrokes, 0, keyIdx);
    }
}

