/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell.korean;

import org.apache.lucene.search.spell.korean.KoHangul;
import org.apache.lucene.search.spell.korean.KoHangulAutomata;

public class KoJamoAutomata
extends KoHangulAutomata {
    public KoJamoAutomata(boolean force) {
        super(force);
    }

    @Override
    protected void feed(char ch) {
        this.rawChar.add(Character.valueOf(ch));
        if (KoHangul.isJamo(ch)) {
            if (KoHangul.isJaeum(ch)) {
                if (this.choSung == '\u0000') {
                    if (this.jwungSung != '\u0000' || this.jongSung != '\u0000') {
                        if (this.forceConvert) {
                            this.pushcomp();
                            this.choSung = ch;
                        } else {
                            this.wordValid = 0;
                        }
                    } else {
                        this.choSung = ch;
                    }
                } else if (this.jwungSung == '\u0000') {
                    if (this.jongSung != '\u0000') {
                        this.wordValid = 0;
                    } else {
                        this.pushcomp();
                        this.choSung = ch;
                    }
                } else if (this.jongSung == '\u0000') {
                    if (KoHangul.getJongsungIdx(ch) == -1) {
                        this.pushcomp();
                        this.choSung = ch;
                    } else {
                        this.jongSung = ch;
                    }
                } else {
                    String jong = KoHangul.getKeyfromCode(this.jongSung);
                    int len = jong.length();
                    if (len == 1) {
                        char[] trymul = new char[10];
                        trymul[0] = jong.charAt(0);
                        trymul[1] = ch;
                        trymul[2] = '\u0000';
                        if (KoHangul.isInKeyCode(new String(trymul))) {
                            this.jongSung = KoHangul.getCodefromKey(new String(trymul));
                        } else {
                            this.pushcomp();
                            this.choSung = ch;
                        }
                    } else if (len == 2) {
                        this.pushcomp();
                        this.choSung = ch;
                    } else assert (false);
                }
            } else if (this.jongSung == '\u0000') {
                if (this.jwungSung == '\u0000') {
                    this.jwungSung = ch;
                } else {
                    char[] trymul = new char[10];
                    String jwung = KoHangul.getKeyfromCode(this.jwungSung);
                    System.arraycopy(jwung.toCharArray(), 0, trymul, 0, jwung.length());
                    trymul[jwung.length()] = ch;
                    trymul[jwung.length() + 1] = '\u0000';
                    if (KoHangul.isInKeyCode(new String(trymul))) {
                        this.jwungSung = KoHangul.getCodefromKey(new String(trymul));
                    } else {
                        this.pushcomp();
                        this.jwungSung = ch;
                    }
                }
            } else {
                String jong = KoHangul.getKeyfromCode(this.jongSung);
                int jongLen = jong.length();
                assert (jongLen > 0 && jongLen < 3);
                if (jongLen > 1) {
                    char[] cArray = new char[2];
                    cArray[0] = jong.charAt(0);
                    char[] strF = cArray;
                    char ojong = KoHangul.getCodefromKey(new String(strF));
                    char[] cArray2 = new char[2];
                    cArray2[0] = jong.charAt(1);
                    char[] strS = cArray2;
                    char ncho = KoHangul.getCodefromKey(new String(strS));
                    this.jongSung = ojong;
                    this.pushcomp();
                    this.choSung = ncho;
                    this.jwungSung = ch;
                } else {
                    char njong = this.jongSung;
                    this.jongSung = '\u0000';
                    this.pushcomp();
                    this.choSung = njong;
                    this.jwungSung = ch;
                }
            }
        } else {
            int isUncompleted = this.finalization();
            if (isUncompleted == 0 || isUncompleted == 2) {
                this.HangulBuffer.add(Character.valueOf(ch));
            }
        }
    }

    public static void main(String[] args) {
        KoJamoAutomata am = new KoJamoAutomata(false);
        System.out.println(am.convert("\u3148\u3153\u3134 \u314e\u3162\u3147\u315d\u3134"));
        am.clear();
        System.out.println(am.convert("sksms wjdakf glaemfdj"));
    }
}

