# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Binary search to find the location of the largest time that is smaller of the pattern
#' 
#' @param array A vector of sorted numbers to search the pattern in
#' @param pattern A number to be searched in the array
#' @return The location of the largest time that is smaller of the pattern
#' 
#' @details This is an inner function inside SG package, not for the users.
binary_search_km_ge <- function(array, pattern) {
    .Call('_KONPsurv_binary_search_km_ge', PACKAGE = 'KONPsurv', array, pattern)
}

#' Binary search to find the location of the largest time that is smaller or equal of the pattern
#' 
#' @param array A vector of sorted numbers to search the pattern in
#' @param pattern A number to be searched in the array
#' @return The location of the largest time that is smaller or equal of the pattern
#' 
#' @details This is an inner function inside SG package, not for the users.
binary_search_km_g <- function(array, pattern) {
    .Call('_KONPsurv_binary_search_km_g', PACKAGE = 'KONPsurv', array, pattern)
}

#' A function to return the test statistic of the SG test
#' 
#' @param s0 A vector of the survival KM estimates in group 0 for all sorted unique times in group 0
#' @param s1 A vector of the survival KM estimates in group 1 for all sorted unique times in group 1
#' @param time0 all sorted unique times in group 0
#' @param time1 all sorted unique times in group 1
#' @param time The follow up time for all the data
#' @param delta A binary status vector, where 0 stands for censored observations and 1 stands for events (corresponds with time)
#' @param trt Group vector, must contain 0 and 1 values only (corresponds with time)
#' @param tau The maximum time in which we can estimate the Kaplan Meier in the two groups
#' @return A list with the two test stats and table usage
#' 
#' @details This is an inner function inside SG package, not for the users.
hhgsurv_test_stat <- function(s0, s1, time0, time1, time, delta, trt, tau) {
    .Call('_KONPsurv_hhgsurv_test_stat', PACKAGE = 'KONPsurv', s0, s1, time0, time1, time, delta, trt, tau)
}

#' An implementation of Kaplan Meier calculation in C++
#' 
#' @param time The follow up time 
#' @param delta A binary status vector, where 0 stands for censored observations and 1 stands for events (corresponds with time)
#' @return The function returns two vectors inside a list \cr
#' 
#' \code{time} - returns the sorted unique time of the data \cr 
#' \code{s} - returns the corresponding KM survival estimates to time
#' 
#' @details This is an inner function inside SG package, not for the users.
KM_C <- function(time, delta) {
    .Call('_KONPsurv_KM_C', PACKAGE = 'KONPsurv', time, delta)
}

#' A function to calculate the permutation test statistics
#' 
#' @param trt The original data Group vector, must contain 0 and 1 values only
#' @param ptrt_mat The permuted treatment matrix for all permutations
#' @param time_original The original data follow up time 
#' @param delta_orginial The original data binary status vector, where 0 stands for censored observations and 1 stands for events 
#' @param imputed_altern_time_vec The time vector for observations that switched groups in permuted sample
#' @param imputed_altern_delta_vec The delta vector for observations that switched groups in permuted sample
#' @param n_perm The number of permutations
#' @return A list with the two permutations test stats vectors and a permutation table usage vector 
#' 
#' @details This is an inner function inside SG package, not for the users.
get_perm_stats <- function(trt, ptrt_mat, time_original, delta_orginial, imputed_altern_time_vec, imputed_altern_delta_vec, n_perm) {
    .Call('_KONPsurv_get_perm_stats', PACKAGE = 'KONPsurv', trt, ptrt_mat, time_original, delta_orginial, imputed_altern_time_vec, imputed_altern_delta_vec, n_perm)
}

#' A function to return the test statistic of the KONP K-sample test
#' 
#' @param s_group A list with the survival KM estimates for all sorted unique times in each group, each group is an element in the list
#' @param time_group  A list with all sorted unique in each group, each group is an element in the list
#' @param n_vec A vector with the sample sizes in each group
#' @param time The follow up time for all the data
#' @param delta A binary status vector, where 0 stands for censored observations and 1 stands for events (corresponds with time)
#' @param trt Group vector, contains the values 1,..,K only, which correspond with time
#' @param tau_k A vector contains maximum times in which we can estimate the Kaplan Meier in each group
#' @param tau The maximum time in which we can estimate the Kaplan Meier in at least two groups
#' @return A list with the two test statistic
#' 
#' @details This is an inner function inside SG package, not for the users.
hhgsurv_test_stat_K_sample <- function(s_group, time_group, n_vec, time, delta, trt, tau_k, tau) {
    .Call('_KONPsurv_hhgsurv_test_stat_K_sample', PACKAGE = 'KONPsurv', s_group, time_group, n_vec, time, delta, trt, tau_k, tau)
}

#' A function to calculate the permutation test statistics for the KONP K-sample test
#' 
#' @param ptrt_mat The permuted treatment matrix for all permutations
#' @param imputed_time_matrix A matrix contianing the time each obsevations will recieve for each group it belongs
#' @param imputed_delta_matrix A matrix contianing the delta each obsevations will recieve for each group it belongs
#' @param n_perm The number of permutations
#' @param n_vec A vector with the sample sizes in each group
#' @return A list with the two permutations test stats vectors 
#' 
#' @details This is an inner function inside SG package, not for the users.
get_perm_stats_K_sample <- function(ptrt_mat, imputed_time_matrix, imputed_delta_matrix, n_perm, n_vec) {
    .Call('_KONPsurv_get_perm_stats_K_sample', PACKAGE = 'KONPsurv', ptrt_mat, imputed_time_matrix, imputed_delta_matrix, n_perm, n_vec)
}

