% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.knockoff.R
\name{generate.knockoff}
\alias{generate.knockoff}
\title{Generate Knockoff Matrix}
\usage{
generate.knockoff(X, type, num, num.comp = 10)
}
\arguments{
\item{X}{An input original design matrix.}

\item{type}{The knockoff type to be generated. There are three choices available: (1) "shrink" for the shrink Gaussian knockoff;
(2) "sparse" for the sparse Gaussian knockoff; and (3) "pc" for the pricial component knockoff.}

\item{num}{The number of knockoff matrices to be created.}

\item{num.comp}{The number of pricial components to be used for generating knockoff matrices, the default is 10.}
}
\value{
A list of created knockoff matrices.
}
\description{
Generate different types of knockoff matrices given an original one.
}
\examples{
set.seed(10)
X <- matrix(rnorm(100), nrow = 10)
Z <- generate.knockoff(X = X, type = "shrink", num = 5)

}
\references{
\insertRef{barber2015controlling}{KOBT}
\insertRef{candes2018panning}{KOBT}
\insertRef{bien2011sparse}{KOBT}
}
