% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predDF}
\alias{predDF}
\alias{predDF.JointAI}
\alias{predDF.formula}
\title{Create a new data frame for prediction}
\usage{
predDF(object, ...)

\method{predDF}{JointAI}(object, vars, length = 100L, ...)

\method{predDF}{formula}(object, data, vars, length = 100L, ...)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{...}{optional specification of the values used for some (or all) of the
variables given in \code{vars}}

\item{vars}{name of variable that should be varying}

\item{length}{number of values used in the sequence when \code{vars} is
continuous}

\item{data}{a \code{data.frame} containing the original data
(more details below)}
}
\description{
Build a \code{data.frame} for prediction, where one variable varies and all
other variables are set to the reference value (median for continuous
variables).
}
\examples{
# fit a JointAI model
mod <- lm_imp(y ~ C1 + C2 + M2, data = wideDF, n.iter = 100)

# generate a data frame with varying "C2" and reference values for all other
# variables in the model
newDF <- predDF(mod, vars = ~ C2)

head(newDF)


newDF2 <- predDF(mod, vars = ~ C2 + M2,
                 C2 = seq(-0.5, 0.5, 0.25),
                 M2 = levels(wideDF$M2)[2:3])
newDF2

}
\seealso{
\code{\link{predict.JointAI}}, \code{\link{lme_imp}},
\code{\link{glm_imp}}, \code{\link{lm_imp}}
}
