% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence_criteria.R
\name{GR_crit}
\alias{GR_crit}
\title{Gelman-Rubin criterion for convergence}
\usage{
GR_crit(object, confidence = 0.95, transform = FALSE,
  autoburnin = TRUE, multivariate = TRUE, subset = NULL,
  start = NULL, end = NULL, thin = NULL, warn = TRUE,
  mess = TRUE, ...)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{confidence}{the coverage probability of the confidence interval for the
potential scale reduction factor}

\item{transform}{a logical flag indicating whether variables in
\code{x} should be transformed to improve the normality of the
distribution. If set to TRUE, a log transform or logit transform, as
appropriate, will be applied.}

\item{autoburnin}{a logical flag indicating whether only the second half
  of the series should be used in the computation.  If set to TRUE
  (default) and \code{start(x)} is less than \code{end(x)/2} then start
  of series will be adjusted so that only second half of series is used.}

\item{multivariate}{a logical flag indicating whether the multivariate
potential scale reduction factor should be calculated for multivariate
chains}

\item{subset}{subset of parameters/variables/nodes (columns in the MCMC sample).
Uses the same logic as the argument \code{monitor_params} in
\code{\link{lm_imp}}, \code{\link{glm_imp}}, \code{\link{clm_imp}},
\code{\link{lme_imp}}, \code{\link{glme_imp}}, \code{\link{survreg_imp}}
and \code{\link{coxph_imp}}.}

\item{start}{the first iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}})}

\item{warn}{logical; should warnings be given? Default is
\code{TRUE}. Note: this applies only to warnings
given directly by \strong{JointAI}.}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}. Note: this applies only to messages
given directly by \strong{JointAI}.}

\item{...}{currently not used}
}
\description{
Calculates the Gelman-Rubin criterion for convergence
(uses \code{\link[coda]{gelman.diag}} from package \strong{coda}).
}
\examples{
mod1 <- lm_imp(y~C1 + C2 + M2, data = wideDF, n.iter = 100)
GR_crit(mod1)



}
\references{
Gelman, A and Rubin, DB (1992) Inference from iterative simulation using
multiple sequences, \emph{Statistical Science}, \strong{7}, 457-511.

Brooks, SP. and Gelman, A. (1998) General methods for monitoring convergence
of iterative simulations.
\emph{Journal of Computational and Graphical Statistics}, \strong{7}, 434-455.
}
\seealso{
The vignette \href{https://nerler.github.io/JointAI/articles/SelectingParameters.html}{Parameter Selection}
contains some examples how to specify the argument \code{subset}.
}
