% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{get_jira_server_info}
\alias{get_jira_server_info}
\title{Get the JIRA server information as a \code{data.frame}}
\usage{
get_jira_server_info(
  domain = NULL,
  username = NULL,
  password = NULL,
  verbose = FALSE
)
}
\arguments{
\item{domain}{Custom JIRA domain URL as for
example \href{https://bugreports.qt.io}{https://bugreports.qt.io}.
Can be passed as a parameter or can be previously defined through
 the \code{save_jira_credentials()} function.}

\item{username}{Username used to authenticate the access to the JIRA \code{domain}.
If both username and password are not passed no authentication is made and only
 public domains can bet accessed. Optional parameter.}

\item{password}{Password used to authenticate the access to the JIRA \code{domain}.
If both username and password are not passed no authentication is made and only
 public domains can bet accessed. Optional parameter.}

\item{verbose}{Explicitly informs the user of the JIRA API request process.}
}
\value{
Returns a \code{data.frame} with all the JIRA server information
}
\description{
Makes a request to JIRA's latest REST API to retrieve all
the necessary information regarding the JIRA server version.
}
\section{Warning}{

The function works with the latest JIRA REST API and to work you need to have
a internet connection. Calling the function too many times might block your
access, you will receive a 403 error code. To unblock your access you will
have to access interactively through your browser, signing out and signing
in again, and might even have to enter a CAPTCHA at https://jira.yourdomain.com/secure/Dashboard.jspa.
This only happens if the API is called upon multiple times in a short period of time.
}

\examples{
\dontrun{
get_jira_server_info("https://bugreports.qt.io")
}
}
\seealso{
For more information about Atlassians JIRA API go
to \href{https://docs.atlassian.com/software/jira/docs/api/REST/8.9.1/}{JIRA API Documentation}
}
