/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Tools.DataScanner;

import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import org.omegahat.Environment.Tools.DataScanner.DataTokenizer;
import org.omegahat.Environment.Tools.DataScanner.EOFException;
import org.omegahat.Environment.Tools.DataScanner.ObjectReader;
import org.omegahat.Environment.Tools.DataScanner.RecordLexer;
import org.omegahat.Environment.Tools.DataScanner.RecordStreamListener;

public class EventDataScanner
implements ObjectReader,
RecordLexer {
    protected Vector listeners = null;
    protected RecordLexer lexer = null;
    protected long maximumRecords = -1L;

    public EventDataScanner() {
    }

    public EventDataScanner(Reader reader) {
        this(new DataTokenizer(reader));
    }

    public EventDataScanner(Reader reader, long l) {
        this(new DataTokenizer(reader), l);
    }

    public EventDataScanner(RecordLexer recordLexer) {
        this.lexer(recordLexer);
    }

    public EventDataScanner(RecordLexer recordLexer, long l) {
        this.lexer(recordLexer);
        this.maximumRecords(l);
    }

    public int addListener(RecordStreamListener recordStreamListener) {
        return this.addListener(recordStreamListener, false);
    }

    public int addListener(RecordStreamListener recordStreamListener, boolean bl) {
        if (this.listeners() == null) {
            this.listeners(new Vector(3));
        }
        if (bl && this.listeners().contains(recordStreamListener)) {
            return -1;
        }
        this.listeners().addElement(recordStreamListener);
        return this.listeners().size();
    }

    public Object currentRecord() {
        return this.lexer().currentRecord();
    }

    public Object endRecord() {
        Object object = this.lexer().endRecord();
        if (object != null) {
            this.notify(object);
        }
        return object;
    }

    public RecordLexer lexer() {
        return this.lexer;
    }

    public RecordLexer lexer(RecordLexer recordLexer) {
        this.lexer = recordLexer;
        return this.lexer();
    }

    public Vector listeners() {
        return this.listeners;
    }

    public Vector listeners(Vector vector2) {
        this.listeners = vector2;
        return this.listeners();
    }

    public long maximumRecords() {
        return this.maximumRecords;
    }

    public long maximumRecords(long l) {
        this.maximumRecords = l;
        return this.maximumRecords();
    }

    public Object nextRecord() throws Exception {
        return this.nextRecord(true);
    }

    public Object nextRecord(boolean bl) throws Exception {
        Object object = this.lexer().nextRecord();
        if (bl) {
            this.notify(object);
        }
        return object;
    }

    public void notify(Object object) {
        if (object == null) {
            return;
        }
        if (this.listeners() == null) {
            return;
        }
        Enumeration enumeration = this.listeners().elements();
        while (enumeration.hasMoreElements()) {
            ((RecordStreamListener)enumeration.nextElement()).newRecord(object, this);
        }
    }

    public long readRecords() throws Throwable {
        return this.readRecords(true);
    }

    public long readRecords(boolean bl) throws Throwable {
        long l = 0L;
        long l2 = this.maximumRecords();
        long l3 = System.currentTimeMillis();
        try {
            while (l2 < 1L || l < l2) {
                this.nextRecord(bl);
                this.endRecord();
                if (++l % 10000L != 0L) continue;
                System.err.println("# records " + l + " " + (double)(System.currentTimeMillis() - l3) / 1000.0);
            }
        }
        catch (EOFException eOFException) {
            this.notify(this.lexer().currentRecord());
            ++l;
        }
        catch (Exception exception) {
            System.out.println("Record exception " + exception);
            throw exception;
        }
        return l;
    }

    public boolean removeListener(RecordStreamListener recordStreamListener) {
        if (this.listeners() == null) {
            return false;
        }
        if (this.listeners().contains(recordStreamListener)) {
            this.listeners().removeElement(recordStreamListener);
        }
        return true;
    }
}

