/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ActionElement;
import antlr.ActionTransInfo;
import antlr.AlternativeBlock;
import antlr.BlockEndElement;
import antlr.CharFormatter;
import antlr.CharLiteralElement;
import antlr.CharRangeElement;
import antlr.DefineGrammarSymbols;
import antlr.Grammar;
import antlr.LLkGrammarAnalyzer;
import antlr.LexerGrammar;
import antlr.OneOrMoreBlock;
import antlr.ParserGrammar;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.ScannerException;
import antlr.StringLiteralElement;
import antlr.StringLiteralSymbol;
import antlr.Token;
import antlr.TokenManager;
import antlr.TokenRangeElement;
import antlr.TokenRefElement;
import antlr.TokenSymbol;
import antlr.Tool;
import antlr.TreeElement;
import antlr.TreeWalkerGrammar;
import antlr.WildcardElement;
import antlr.ZeroOrMoreBlock;
import antlr.actions.ActionLexer;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class CodeGenerator {
    protected int tabs;
    protected transient PrintWriter currentOutput;
    protected Grammar grammar;
    protected Vector bitsetsUsed;
    protected Tool tool;
    protected DefineGrammarSymbols behavior;
    protected LLkGrammarAnalyzer analyzer;
    protected CharFormatter charFormatter;
    protected boolean DEBUG_CODE_GENERATOR = false;
    protected static final int DEFAULT_MAKE_SWITCH_THRESHOLD = 2;
    protected static final int DEFAULT_BITSET_TEST_THRESHOLD = 4;
    protected int makeSwitchThreshold = 2;
    protected int bitsetTestThreshold = 4;
    private static boolean OLD_ACTION_TRANSLATOR = true;

    protected void _print(String string) {
        if (string != null) {
            this.currentOutput.print(string);
        }
    }

    protected void _printAction(String string) {
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < string.length() && Character.isSpaceChar(string.charAt(n))) {
            ++n;
        }
        int n2 = string.length() - 1;
        while (n2 > n && Character.isSpaceChar(string.charAt(n2))) {
            --n2;
        }
        char c = '\u0000';
        int n3 = n;
        while (n3 <= n2) {
            c = string.charAt(n3);
            ++n3;
            boolean bl = false;
            switch (c) {
                case '\n': {
                    bl = true;
                    break;
                }
                case '\r': {
                    if (n3 <= n2 && string.charAt(n3) == '\n') {
                        ++n3;
                    }
                    bl = true;
                    break;
                }
                default: {
                    this.currentOutput.print(c);
                }
            }
            if (!bl) continue;
            this.currentOutput.println();
            this.printTabs();
            while (n3 <= n2 && Character.isSpaceChar(string.charAt(n3))) {
                ++n3;
            }
            bl = false;
        }
        this.currentOutput.println();
    }

    protected void _println(String string) {
        if (string != null) {
            this.currentOutput.println(string);
        }
    }

    public static boolean elementsAreRange(int[] nArray) {
        if (nArray.length == 0) {
            return false;
        }
        int n = nArray[0];
        int n2 = nArray[nArray.length - 1];
        if (nArray.length <= 2) {
            return false;
        }
        if (n2 - n + 1 > nArray.length) {
            return false;
        }
        int n3 = n + 1;
        int n4 = 1;
        while (n4 < nArray.length - 1) {
            if (n3 != nArray[n4]) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    protected String extractIdOfAction(Token token) {
        return this.extractIdOfAction(token.getText(), token.getLine());
    }

    protected String extractIdOfAction(String string, int n) {
        int n2 = string.length() - 2;
        while (n2 >= 0) {
            if (!Character.isLetterOrDigit(string.charAt(n2)) && string.charAt(n2) != '_') {
                return string.substring(n2 + 1);
            }
            --n2;
        }
        Tool.warning("Ill-formed action", n);
        return "";
    }

    protected String extractTypeOfAction(Token token) {
        return this.extractTypeOfAction(token.getText(), token.getLine());
    }

    protected String extractTypeOfAction(String string, int n) {
        int n2 = string.length() - 2;
        while (n2 >= 0) {
            if (!Character.isLetterOrDigit(string.charAt(n2)) && string.charAt(n2) != '_') {
                return string.substring(0, n2 + 1);
            }
            --n2;
        }
        Tool.warning("Ill-formed action", n);
        return "";
    }

    public abstract void gen();

    public abstract void gen(ActionElement var1);

    public abstract void gen(AlternativeBlock var1);

    public abstract void gen(BlockEndElement var1);

    public abstract void gen(CharLiteralElement var1);

    public abstract void gen(CharRangeElement var1);

    public abstract void gen(LexerGrammar var1) throws IOException;

    public abstract void gen(OneOrMoreBlock var1);

    public abstract void gen(ParserGrammar var1) throws IOException;

    public abstract void gen(RuleRefElement var1);

    public abstract void gen(StringLiteralElement var1);

    public abstract void gen(TokenRangeElement var1);

    public abstract void gen(TokenRefElement var1);

    public abstract void gen(TreeElement var1);

    public abstract void gen(TreeWalkerGrammar var1) throws IOException;

    public abstract void gen(WildcardElement var1);

    public abstract void gen(ZeroOrMoreBlock var1);

    protected void genTokenInterchange(TokenManager tokenManager) throws IOException {
        this.currentOutput = Tool.openOutputFile(String.valueOf(tokenManager.getName()) + "TokenTypes.txt");
        this.tabs = 0;
        this.println(String.valueOf(tokenManager.getName()) + "    // tokenVocabulary name");
        Vector vector = tokenManager.getVocabulary();
        int n = 4;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("gen persistence file entry for: " + string);
            }
            if (string != null && !string.startsWith("<")) {
                TokenSymbol tokenSymbol;
                if (string.startsWith("\"")) {
                    tokenSymbol = (StringLiteralSymbol)this.grammar.tokenManager.getTokenSymbol(string);
                    if (tokenSymbol != null && ((StringLiteralSymbol)tokenSymbol).label != null) {
                        this.print(String.valueOf(((StringLiteralSymbol)tokenSymbol).label) + "=");
                    }
                    this.println(String.valueOf(string) + "=" + n);
                } else {
                    this.print(string);
                    tokenSymbol = this.grammar.tokenManager.getTokenSymbol(string);
                    if (tokenSymbol.getParaphrase() != null) {
                        this.print("(" + tokenSymbol.getParaphrase() + ")");
                    }
                    this.println("=" + n);
                }
            }
            ++n;
        }
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public abstract String getASTCreateString(Vector var1);

    public abstract String getASTCreateString(String var1);

    protected String getBitsetName(int n) {
        return "_tokenSet_" + n;
    }

    public static String lexerRuleName(String string) {
        return "m" + string;
    }

    public abstract String mapTreeId(String var1, ActionTransInfo var2);

    protected int markBitsetForGen(BitSet bitSet) {
        int n = 0;
        while (n < this.bitsetsUsed.size()) {
            BitSet bitSet2 = (BitSet)this.bitsetsUsed.elementAt(n);
            if (bitSet.equals(bitSet2)) {
                return n;
            }
            ++n;
        }
        this.bitsetsUsed.appendElement(bitSet.clone());
        return this.bitsetsUsed.size() - 1;
    }

    protected void print(String string) {
        if (string != null) {
            this.printTabs();
            this.currentOutput.print(string);
        }
    }

    protected void printAction(String string) {
        if (string != null) {
            this.printTabs();
            this._printAction(string);
        }
    }

    protected void println(String string) {
        if (string != null) {
            this.printTabs();
            this.currentOutput.println(string);
        }
    }

    protected void printTabs() {
        int n = 1;
        while (n <= this.tabs) {
            this.currentOutput.print("\t");
            ++n;
        }
    }

    protected String processActionForTreeSpecifiers(String string, int n, RuleBlock ruleBlock, ActionTransInfo actionTransInfo) {
        if (string == null) {
            return null;
        }
        if (this.grammar == null) {
            return string;
        }
        if (this.grammar.buildAST && string.indexOf(35) != -1 || this.grammar instanceof LexerGrammar && string.indexOf(36) != -1) {
            ActionLexer actionLexer = new ActionLexer(string, ruleBlock, this, actionTransInfo);
            actionLexer.setLineOffset(n);
            actionLexer.setTool(this.tool);
            try {
                actionLexer.mACTION(true);
                string = actionLexer.getTokenObject().getText();
            }
            catch (ScannerException scannerException) {
                actionLexer.reportError(scannerException);
                return string;
            }
            catch (IOException iOException) {
                Tool.panic("IO error reading action:" + string);
                return string;
            }
        }
        return string;
    }

    private void reset() {
        this.tabs = 0;
        this.bitsetsUsed = new Vector();
        this.currentOutput = null;
        this.grammar = null;
        this.DEBUG_CODE_GENERATOR = false;
        this.makeSwitchThreshold = 2;
        this.bitsetTestThreshold = 4;
    }

    public static String reverseLexerRuleName(String string) {
        return string.substring(1, string.length());
    }

    public void setAnalyzer(LLkGrammarAnalyzer lLkGrammarAnalyzer) {
        this.analyzer = lLkGrammarAnalyzer;
    }

    public void setBehavior(DefineGrammarSymbols defineGrammarSymbols) {
        this.behavior = defineGrammarSymbols;
    }

    protected void setGrammar(Grammar grammar) {
        this.reset();
        this.grammar = grammar;
        if (this.grammar.hasOption("codeGenMakeSwitchThreshold")) {
            try {
                this.makeSwitchThreshold = this.grammar.getIntegerOption("codeGenMakeSwitchThreshold");
            }
            catch (NumberFormatException numberFormatException) {
                this.tool.error("option 'codeGenMakeSwitchThreshold' must be an integer", this.grammar.getOption("codeGenMakeSwitchThreshold").getLine());
            }
        }
        if (this.grammar.hasOption("codeGenBitsetTestThreshold")) {
            try {
                this.bitsetTestThreshold = this.grammar.getIntegerOption("codeGenBitsetTestThreshold");
            }
            catch (NumberFormatException numberFormatException) {
                this.tool.error("option 'codeGenBitsetTestThreshold' must be an integer", this.grammar.getOption("codeGenBitsetTestThreshold").getLine());
            }
        }
        if (this.grammar.hasOption("codeGenDebug")) {
            Token token = this.grammar.getOption("codeGenDebug");
            if (token.getText().equals("true")) {
                this.DEBUG_CODE_GENERATOR = true;
                return;
            }
            if (token.getText().equals("false")) {
                this.DEBUG_CODE_GENERATOR = false;
                return;
            }
            this.tool.error("option 'codeGenDebug' must be true or false", token.getLine());
        }
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }
}

