% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_assumptions.R
\name{check_assumptions}
\alias{check_assumptions}
\title{Test assumptions for models underlying the mediation}
\usage{
check_assumptions(
  mediation_model,
  tests = c("normality", "heteroscedasticity")
)
}
\arguments{
\item{mediation_model}{An object of class \code{mediation_model}.}

\item{tests}{A character vector indicating which test to run. Supported test
includes \code{"normality"}, \code{"heteroscedasticity"}, and
\code{"outliers"}}
}
\value{
Invisibly returns an object of class \code{mediation_model}.
}
\description{
When conducting a joint-significant test, different models are
fitted to the data. This function tests assumptions regarding these models
using the \code{performance} package.

The assumptions test are performed using
\code{\link[performance]{check_normality}},
\code{\link[performance]{check_heteroscedasticity}}, and
\code{\link[performance]{check_outliers}}.

Note that \code{check_assumptions} returns a \code{mediation_model} object.
}
\examples{
\dontshow{if (rlang::is_installed("performance")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

data(ho_et_al)

ho_et_al$condition_c <- build_contrast(ho_et_al$condition,
                                       "Low discrimination",
                                       "High discrimination")

my_model <-
  mdt_simple(data = ho_et_al,
             IV = condition_c,
             DV = hypodescent,
             M = linkedfate)

check_assumptions(my_model)
\dontshow{\}) # examplesIf}
}
\seealso{
Other assumption checks: 
\code{\link{plot_assumptions}()}
}
\concept{assumption checks}
