% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ps2DNormal.R
\name{plot.ps2dnormal}
\alias{plot.ps2dnormal}
\title{Plotting function for \code{ps2DNormal}}
\usage{
\method{plot}{ps2dnormal}(x, ..., xlab = " ", ylab = " ", Resol = 100)
}
\arguments{
\item{x}{the P-spline object, usually from \code{ps2DNormal}.}

\item{...}{other parameters.}

\item{xlab}{label for the x-axis, e.g. "my x" (quotes required).}

\item{ylab}{label for the y-axis, e.g. "my y" (quotes required).}

\item{Resol}{resolution for plotting, default \code{Resol = 100}.}
}
\value{
\item{Plot}{a plot of the smooth 2D P-spline smooth surface.}
}
\description{
Plotting function for 2D P-spline smooothing
(using \code{ps2DNormal} with \code{class ps2dnormal}).
}
\examples{
library(SemiPar)
library(fields)
library(spam)
library(JOPS)

# Get the data
data(ethanol)
x <- ethanol$C
y <- ethanol$E
z <- ethanol$NOx

# Set parameters for domain
xlo <- 7
xhi <- 19
ylo <- 0.5
yhi <- 1.25

# Set P-spline parameters, fit and compute surface
xpars <- c(xlo, xhi, 10, 3, 3, 1)
ypars <- c(ylo, yhi, 10, 3, 3, 1)
Pars1 <- rbind(xpars, ypars)
fit <- ps2DNormal(cbind(x, y, z), Pars = Pars1)
plot(fit, xlab = "C", ylab = "E")
}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

Eilers, P.H.C., Marx, B.D., and Durban, M. (2015).
Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.
}
\author{
Paul Eilers and Brian Marx
}
