% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbase.R
\name{bbase}
\alias{bbase}
\title{Compute a B-spline basis matrix}
\usage{
bbase(x, xl = min(x), xr = max(x), nseg = 10, bdeg = 3)
}
\arguments{
\item{x}{a vector of argument values, at which the B-spline basis functions
are to be evaluated.}

\item{xl}{the lower limit of the domain of x; default is \code{min(x)}.}

\item{xr}{the upper limit of the domain of x; default is \code{max(x)}.}

\item{nseg}{the number of equally sized segments between xl and xr; default is 10.}

\item{bdeg}{the degree of the splines, usually 1, 2, or 3 (default).}
}
\value{
A matrix with  \code{length(x)} rows and \code{nseg + bdeg} columns.
}
\description{
Compute a B-spline basis matrix using evenly spaced knots.
}
\details{
If \code{xl} is larger than \code{min(x)}, it will be adjusted to \code{min(x)} and a warning wil be given.
If \code{xr} is smaller than \code{max(x)}, it will be adjusted to \code{max(x)} and a warning wil be given.
The values of the design parameters \code{x, xl, xr, ndeg, bdeg} and \code{type = 'bbase'} are added to the list of attributes of the matrix.
}
\examples{
# Compute and plot a B-spline basis matrix
x = seq(0, 360, by = 2)
B = bbase(x, 0, 360, nseg = 8, bdeg = 3)
matplot(x, B, type = 'l', lty = 1, lwd = 2, xlab = 'x', ylab = '')

}
\references{
Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

Eilers, P.H.C. and Marx, B.D. (1996). Flexible smoothing with
B-splines and penalties (with comments and rejoinder), \emph{Statistical Science},
11: 89-121.

Eilers, P.H.C. and B.D. Marx (2010).
Splines, knots and penalties. Wiley Interdisciplinary
Reviews: Computational Statistics. Wiley: NY. DOI: 10.1002/wics.125
}
\author{
Paul Eilers and Brian Marx
}
