/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.editor.FindReplaceDialog;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.IconButton;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.DocumentRenderer;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;

public class JGRHelp
extends TJFrame
implements ActionListener,
KeyListener,
MouseListener {
    private static final long serialVersionUID = 674422754541012924L;
    public static JGRHelp current = null;
    private final String keyWord;
    private final JPanel topPanel = new JPanel();
    private final JTabbedPane tabArea = new JTabbedPane();
    private HelpArea helpArea;
    private final JTextField inputKeyWord = new JTextField();
    private final JButton search = new JButton("Search");
    public JLabel link = new JLabel(" ");
    private final JPanel options = new JPanel(new FlowLayout(1));
    private final JCheckBox exactMatch = new JCheckBox("Exact Match", true);
    private final JCheckBox searchDesc = new JCheckBox("Help Page Titles", true);
    private final JCheckBox searchKeyWords = new JCheckBox("Keywords", false);
    private final JCheckBox searchAliases = new JCheckBox("Object Names", false);
    private final JCheckBox searchConcepts = new JCheckBox("Concepts", false);
    private IconButton back;
    private IconButton forward;
    private static String index;
    private static String server;
    private static String searchString;

    public JGRHelp() {
        this(null);
    }

    public static void showURL(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (current == null) {
                    current = new JGRHelp(string);
                } else {
                    current.showURLInternal(string, null);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void showURLInternal(String string, String string2) {
        if (string != null && !string.equals("")) {
            try {
                if (this.tabArea.getComponents().length > 0 && ((HelpArea)this.tabArea.getComponentAt((int)0)).helpPane.getText().indexOf("No matches for") >= 0) {
                    this.tabArea.remove(0);
                }
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
            String string3 = "Help";
            if (string2 != null) {
                string3 = "Result: " + string2;
            } else if (string.indexOf("/doc/html/Search?") > 0) {
                string3 = "Seach Result ";
            } else {
                try {
                    string3 = string.toString().substring(string.toString().lastIndexOf("/") + 1);
                    string3 = string3.substring(0, string3.lastIndexOf(46));
                }
                catch (Exception exception) {
                    new ErrorMsg(exception);
                }
            }
            if (this.tabArea.getTabCount() == JGRPrefs.maxHelpTabs) {
                this.tabArea.remove(JGRPrefs.maxHelpTabs - 1);
            }
            this.tabArea.add((Component)new HelpArea(this.tabArea, this, string), 0);
            this.tabArea.setSelectedIndex(0);
            this.tabArea.setIconAt(0, new CloseIcon(current.getClass().getResource("/icons/close.png")));
            this.tabArea.setTitleAt(0, string3);
        }
    }

    public JGRHelp(String string) {
        super("Help", false, 16);
        Object object;
        this.keyWord = null;
        while (!JGR.STARTED) {
        }
        String[] stringArray = new String[]{"+", "File", "@PPrint", "print", "+", "Edit", "@CCopy", "copy", "-", "@RRun selection", "runselection", "@FFind", "search", "@GFind Next", "searchnext", "~Window", "~About", "0"};
        EzMenuSwing.getEzMenu((JFrame)((Object)this), (ActionListener)this, (String[])stringArray);
        if (string != null) {
            int n = string.indexOf("127.0.0.1");
            if (n > 0) {
                int n2 = string.indexOf("/", n + "127.0.0.1".length());
                server = string.substring(0, n2);
            }
        } else {
            try {
                REXP rEXP = JGR.eval("tools:::httpdPort");
                server = "http://127.0.0.1:" + rEXP.asString();
            }
            catch (REngineException rEngineException) {
                new ErrorMsg(rEngineException);
            }
            catch (REXPMismatchException rEXPMismatchException) {
                new ErrorMsg(rEXPMismatchException);
            }
        }
        try {
            object = JGR.eval("version$minor");
            searchString = Double.parseDouble(((REXP)object).asString()) >= 14.0 ? "pattern" : "name";
        }
        catch (REngineException rEngineException) {
            rEngineException.printStackTrace();
            new ErrorMsg(rEngineException);
            searchString = "name";
        }
        catch (REXPMismatchException rEXPMismatchException) {
            new ErrorMsg(rEXPMismatchException);
            rEXPMismatchException.printStackTrace();
            searchString = "name";
        }
        index = server + "/doc/html/packages.html";
        this.search.setActionCommand("searchHelp");
        this.search.addActionListener(this);
        this.getRootPane().setDefaultButton(this.search);
        FontTracker.current.add(this.inputKeyWord);
        this.inputKeyWord.setMinimumSize(new Dimension(150, 25));
        this.inputKeyWord.setPreferredSize(new Dimension(300, 25));
        this.inputKeyWord.setMaximumSize(new Dimension(350, 25));
        this.inputKeyWord.setEditable(true);
        this.options.add(this.exactMatch);
        this.options.add(this.searchDesc);
        this.options.add(this.searchKeyWords);
        this.options.add(this.searchAliases);
        this.options.add(this.searchConcepts);
        object = new JPanel(new FlowLayout(0));
        ((Container)object).add(this.inputKeyWord);
        ((Container)object).add(this.search);
        ((Container)object).add(new Spacer(30));
        this.back = new IconButton("/icons/back.png", "Back", this, "back");
        ((Container)object).add(this.back);
        ((Container)object).add(new IconButton("/icons/home.png", "Home", this, "home"));
        this.forward = new IconButton("/icons/forward.png", "Forward", this, "forward");
        ((Container)object).add(this.forward);
        this.topPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.topPanel.add((Component)object, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.topPanel.add((Component)this.options, gridBagConstraints);
        this.back.setEnabled(false);
        this.forward.setEnabled(false);
        this.link.setPreferredSize(new Dimension(200, 20));
        this.helpArea = new HelpArea(this.tabArea, this, null);
        this.helpArea.addKeyListener(this);
        this.tabArea.addTab(this.keyWord == null ? "packages" : this.keyWord, new CloseIcon(this.getClass().getResource("/icons/close.png")), this.helpArea);
        this.tabArea.addMouseListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.topPanel, "North");
        this.getContentPane().add((Component)this.tabArea, "Center");
        this.getContentPane().add((Component)this.link, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JGRHelp.this.exit();
            }
        });
        this.setMinimumSize(new Dimension(570, 600));
        this.setSize(new Dimension(600, Common.screenRes.height < 800 ? Common.screenRes.height - 50 : 700));
        this.setLocation(Common.screenRes.width - this.getSize().width - 50, 10);
        super.setVisible(true);
        this.inputKeyWord.requestFocus();
        current = this;
        if (string != null) {
            this.showURLInternal(string, null);
        }
    }

    public void print() {
        DocumentRenderer documentRenderer = new DocumentRenderer();
        documentRenderer.print(((HelpArea)this.tabArea.getSelectedComponent()).helpPane);
    }

    private void back() {
        ((HelpArea)this.tabArea.getSelectedComponent()).back();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JGRHelp.this.helpArea.reposition();
            }
        });
    }

    private void home() {
        ((HelpArea)this.tabArea.getSelectedComponent()).goTo(index, true);
    }

    private void forward() {
        ((HelpArea)this.tabArea.getSelectedComponent()).forward();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JGRHelp.this.helpArea.reposition();
            }
        });
    }

    private void exit() {
        current = null;
        this.finalize();
        this.dispose();
    }

    public void search() {
        String string = this.inputKeyWord.getText().trim();
        if (string == null) {
            return;
        }
        this.search(string);
    }

    public void search(String string) {
        if (string == null) {
            return;
        }
        String string2 = server + "/doc/html/Search?" + searchString + "=" + string.trim();
        if (this.exactMatch.isSelected()) {
            string2 = string2 + "&exact=1";
        }
        if (this.searchDesc.isSelected()) {
            string2 = string2 + "&title=1";
        }
        if (this.searchKeyWords.isSelected()) {
            string2 = string2 + "keyword=1";
        }
        if (this.searchAliases.isSelected()) {
            string2 = string2 + "alias=1";
        }
        if (this.searchConcepts.isSelected()) {
            string2 = string2 + "concept=1";
        }
        this.showURLInternal(string2, string.trim());
    }

    public static void searchHelp(String string) {
        if (current == null) {
            current = new JGRHelp();
            current.search(string);
        } else {
            current.search(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "back") {
            this.back();
        } else if (string == "copy") {
            ((HelpArea)this.tabArea.getSelectedComponent()).helpPane.copy();
        } else if (string == "exit") {
            this.exit();
        } else if (string == "forward") {
            this.forward();
        } else if (string == "home") {
            try {
                this.home();
            }
            catch (Exception exception) {
                new ErrorMsg(exception);
            }
        } else if (string == "print") {
            this.print();
        } else if (string == "runselection") {
            try {
                String string2 = ((HelpArea)this.tabArea.getSelectedComponent()).helpPane.getSelectedText().trim();
                if (string2.length() > 0) {
                    JGR.MAINRCONSOLE.execute(string2.trim(), true);
                }
            }
            catch (Exception exception) {}
        } else if (string == "selAll") {
            ((HelpArea)this.tabArea.getSelectedComponent()).helpPane.selectAll();
        } else if (string == "searchHelp") {
            this.search();
        } else if (string == "search") {
            FindReplaceDialog.findExt((Frame)((Object)this), ((HelpArea)this.tabArea.getSelectedComponent()).helpPane);
        } else if (string == "searchnext") {
            FindReplaceDialog.findNextExt((Frame)((Object)this), ((HelpArea)this.tabArea.getSelectedComponent()).helpPane);
        } else if (string == "tab_close") {
            this.tabArea.remove(this.tabArea.getSelectedIndex());
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (System.getProperty("os.name").indexOf("Mac") == -1) {
            this.getRootPane().setDefaultButton(this.search);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && keyEvent.isControlDown() && System.getProperty("os.name").indexOf("Mac") == -1) {
            try {
                if (((JTextComponent)keyEvent.getComponent()).getSelectedText().trim().length() > 0) {
                    this.getRootPane().setDefaultButton(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        String string;
        if ((keyEvent.isMetaDown() || keyEvent.isControlDown()) && keyEvent.getKeyCode() == 10 && (string = ((JTextComponent)keyEvent.getComponent()).getSelectedText().trim()).length() > 0) {
            JGR.MAINRCONSOLE.execute(string, true);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.tabArea.getUI().tabForCoordinate(this.tabArea, mouseEvent.getX(), mouseEvent.getY());
        if (n < 0) {
            return;
        }
        Rectangle rectangle = ((CloseIcon)this.tabArea.getIconAt(n)).getBounds();
        if (rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.tabArea.remove(n);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    class Spacer
    extends JPanel {
        private static final long serialVersionUID = -6276846968522042614L;

        public Spacer(int n) {
            this.setMinimumSize(new Dimension(n, 0));
            this.setMaximumSize(new Dimension(n, 0));
            this.setPreferredSize(new Dimension(n, 0));
        }
    }

    class CloseIcon
    extends ImageIcon {
        private static final long serialVersionUID = 7083118485073055561L;
        private int x;
        private int y;
        private int width;
        private int height;

        public CloseIcon(URL uRL) {
            super(uRL);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.x = n;
            this.y = n2;
            this.width = this.getIconWidth();
            this.height = this.getIconHeight();
            super.paintIcon(component, graphics, n, n2);
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }
    }

    public class HelpArea
    extends JScrollPane {
        private static final long serialVersionUID = -6175984770162069827L;
        public JEditorPane helpPane = new JEditorPane();
        private JGRHelp rhelp;
        private final Vector history = new Vector();
        private final Vector viewportLocationHistory = new Vector();
        private int currentURLIndex = -1;
        private JTabbedPane tabArea = null;

        public HelpArea(JTabbedPane jTabbedPane, JGRHelp jGRHelp2, String string) {
            this.rhelp = jGRHelp2;
            this.tabArea = jTabbedPane;
            FontTracker.current.add(this.helpPane);
            this.getViewport().add(this.helpPane);
            this.setVerticalScrollBarPolicy(22);
            this.helpPane.setEditable(false);
            this.helpPane.setContentType("text/html");
            this.helpPane.addKeyListener(jGRHelp2);
            this.helpPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                        if (((HelpArea)HelpArea.this).JGRHelp.this.link != null) {
                            ((HelpArea)HelpArea.this).JGRHelp.this.link.setText(hyperlinkEvent.getURL().toString());
                        }
                    } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                        if (((HelpArea)HelpArea.this).JGRHelp.this.link != null) {
                            ((HelpArea)HelpArea.this).JGRHelp.this.link.setText(" ");
                        }
                    } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        HelpArea.this.goTo(hyperlinkEvent.getURL(), true);
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent componentEvent) {
                    HelpArea.this.setButtons();
                }
            });
            if (string == null) {
                this.goTo(index);
            } else {
                this.goTo(string);
            }
        }

        private void setButtons() {
            JGRHelp.this.back.setEnabled(this.currentURLIndex > 0);
            JGRHelp.this.forward.setEnabled(this.currentURLIndex + 1 < this.history.size());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void updatePage(boolean bl) {
            block28: {
                URL uRL;
                block27: {
                    this.rhelp.setWorking(true);
                    this.rhelp.back.setEnabled(this.currentURLIndex > 0);
                    this.rhelp.forward.setEnabled(this.currentURLIndex + 1 < this.history.size());
                    uRL = (URL)this.history.get(this.currentURLIndex);
                    this.helpPane.setPage(uRL);
                    Object var6_3 = null;
                    if (!bl) break block27;
                    try {
                        String string = uRL.toString().substring(uRL.toString().lastIndexOf("/") + 1);
                        string = string.substring(0, Math.max(0, string.lastIndexOf(46)));
                        int n = this.tabArea.getSelectedIndex();
                        if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("http")) {
                            this.tabArea.setTitleAt(n, string);
                        } else {
                            int n2 = uRL.toString().indexOf("htm");
                            string = uRL.toString().substring(0, n2 - 1);
                            string = string.substring(string.lastIndexOf("/") + 1);
                            if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("http")) {
                                this.tabArea.setTitleAt(n, string);
                            }
                        }
                        this.getViewport().setViewPosition((Point)this.viewportLocationHistory.get(this.currentURLIndex));
                    }
                    catch (Exception exception) {
                        new ErrorMsg(exception);
                    }
                }
                this.rhelp.setWorking(false);
                {
                    break block28;
                    catch (IOException iOException) {
                        new ErrorMsg(iOException);
                        try {
                            this.history.remove(this.currentURLIndex);
                            this.viewportLocationHistory.remove(this.currentURLIndex);
                            --this.currentURLIndex;
                            this.rhelp.back.setEnabled(this.currentURLIndex > 0);
                            this.rhelp.forward.setEnabled(this.currentURLIndex + 1 < this.history.size());
                            uRL = (URL)this.history.get(this.currentURLIndex);
                        }
                        catch (Exception exception) {
                            new ErrorMsg(exception);
                            JOptionPane.showMessageDialog(this, iOException.getMessage(), "URL Error", 0);
                        }
                        Object var6_4 = null;
                        if (bl) {
                            try {
                                String string = uRL.toString().substring(uRL.toString().lastIndexOf("/") + 1);
                                string = string.substring(0, Math.max(0, string.lastIndexOf(46)));
                                int n = this.tabArea.getSelectedIndex();
                                if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("http")) {
                                    this.tabArea.setTitleAt(n, string);
                                } else {
                                    int n3 = uRL.toString().indexOf("htm");
                                    string = uRL.toString().substring(0, n3 - 1);
                                    string = string.substring(string.lastIndexOf("/") + 1);
                                    if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("http")) {
                                        this.tabArea.setTitleAt(n, string);
                                    }
                                }
                                this.getViewport().setViewPosition((Point)this.viewportLocationHistory.get(this.currentURLIndex));
                            }
                            catch (Exception exception) {
                                new ErrorMsg(exception);
                            }
                        }
                        this.rhelp.setWorking(false);
                        break block28;
                    }
                    catch (Exception exception) {
                        new ErrorMsg(exception);
                        Object var6_5 = null;
                        if (bl) {
                            try {
                                String string = uRL.toString().substring(uRL.toString().lastIndexOf("/") + 1);
                                string = string.substring(0, Math.max(0, string.lastIndexOf(46)));
                                int n = this.tabArea.getSelectedIndex();
                                if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("http")) {
                                    this.tabArea.setTitleAt(n, string);
                                } else {
                                    int n4 = uRL.toString().indexOf("htm");
                                    string = uRL.toString().substring(0, n4 - 1);
                                    string = string.substring(string.lastIndexOf("/") + 1);
                                    if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("http")) {
                                        this.tabArea.setTitleAt(n, string);
                                    }
                                }
                                this.getViewport().setViewPosition((Point)this.viewportLocationHistory.get(this.currentURLIndex));
                            }
                            catch (Exception exception2) {
                                new ErrorMsg(exception2);
                            }
                        }
                        this.rhelp.setWorking(false);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (bl) {
                        try {
                            String string = uRL.toString().substring(uRL.toString().lastIndexOf("/") + 1);
                            string = string.substring(0, Math.max(0, string.lastIndexOf(46)));
                            int n = this.tabArea.getSelectedIndex();
                            if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("http")) {
                                this.tabArea.setTitleAt(n, string);
                            } else {
                                int n5 = uRL.toString().indexOf("htm");
                                string = uRL.toString().substring(0, n5 - 1);
                                string = string.substring(string.lastIndexOf("/") + 1);
                                if (n >= 0 && !string.matches("^[0-9][0-9].*") || string.startsWith("http")) {
                                    this.tabArea.setTitleAt(n, string);
                                }
                            }
                            this.getViewport().setViewPosition((Point)this.viewportLocationHistory.get(this.currentURLIndex));
                        }
                        catch (Exception exception) {
                            new ErrorMsg(exception);
                        }
                    }
                    this.rhelp.setWorking(false);
                    throw throwable;
                }
            }
            this.getViewport().setViewPosition((Point)this.viewportLocationHistory.get(this.currentURLIndex));
        }

        private void back() {
            if (this.currentURLIndex + 2 < this.viewportLocationHistory.size()) {
                this.viewportLocationHistory.setElementAt(this.getViewport().getViewPosition(), this.currentURLIndex + 1);
            } else {
                this.viewportLocationHistory.add(this.getViewport().getViewPosition());
            }
            --this.currentURLIndex;
            this.updatePage(true);
        }

        private void forward() {
            this.viewportLocationHistory.setElementAt(this.getViewport().getViewPosition(), this.currentURLIndex + 1);
            ++this.currentURLIndex;
            this.updatePage(true);
        }

        public void reposition() {
            try {
                Thread.sleep(100L);
                this.getViewport().setViewPosition((Point)this.viewportLocationHistory.get(this.currentURLIndex + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void goTo(URL uRL) {
            this.goTo(uRL, false);
        }

        public void goTo(URL uRL, boolean bl) {
            if (uRL != null) {
                ++this.currentURLIndex;
                this.history.setSize(this.currentURLIndex);
                this.history.add(uRL);
                this.viewportLocationHistory.setSize(this.currentURLIndex);
                this.viewportLocationHistory.add(this.getViewport().getViewPosition());
                this.updatePage(bl);
            }
        }

        public void goTo(String string) {
            this.goTo(string, false);
        }

        public void goTo(String string, boolean bl) {
            URL uRL = null;
            try {
                uRL = new URL(string);
                this.goTo(uRL, bl);
            }
            catch (MalformedURLException malformedURLException) {
                new ErrorMsg(malformedURLException);
                JOptionPane.showMessageDialog(null, malformedURLException.getMessage(), "URL Error", 0);
                return;
            }
        }
    }
}

