/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;
import org.rosuda.JGR.layout.AnchorConstraint;

public class AnchorLayout
implements LayoutManager2 {
    private int preferredWidth;
    private int preferredHeight;
    private int minHeight;
    private int minWidth;
    private HashMap constraintMap = new HashMap();
    private boolean sizesCalculated = false;
    private Container container;

    void initialize(Container container) {
        if (this.sizesCalculated) {
            return;
        }
        Component[] componentArray = container.getComponents();
        this.preferredWidth = 10000;
        this.preferredHeight = 10000;
        this.minWidth = 0;
        this.minHeight = 0;
        Rectangle rectangle = container.getBounds();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component == null) continue;
            Object v = this.constraintMap.get(component);
            Rectangle rectangle2 = component.getBounds();
            Dimension dimension = component.getPreferredSize();
            Dimension dimension2 = component.getMaximumSize();
            if (dimension == null) {
                dimension = component.getSize();
            }
            if (dimension2 == null) {
                dimension2 = component.getSize();
            }
            int n = rectangle2.x + rectangle2.width;
            int n2 = rectangle2.y + rectangle2.height;
            int n3 = rectangle2.x + rectangle2.width;
            int n4 = rectangle2.y + rectangle2.height;
            if (v instanceof AnchorConstraint) {
                AnchorConstraint anchorConstraint = (AnchorConstraint)v;
                int n5 = anchorConstraint.left;
                int n6 = anchorConstraint.right;
                int n7 = anchorConstraint.leftType;
                int n8 = anchorConstraint.rightType;
                if (n7 == 1) {
                    n5 = n5 * rectangle.width / 1000;
                }
                if (n8 == 1) {
                    n6 = rectangle.width - n6 * rectangle.width / 1000;
                }
                if (n7 != 0 && n8 != 0) {
                    n3 = n5 + dimension.width + n6;
                }
                if (n7 == 0) {
                    n5 = 0;
                }
                if (n8 == 0) {
                    n6 = 0;
                }
                n = n5 + dimension2.width + n6;
                int n9 = anchorConstraint.top;
                int n10 = anchorConstraint.bottom;
                int n11 = anchorConstraint.topType;
                int n12 = anchorConstraint.bottomType;
                if (n11 == 1) {
                    n9 = n9 * rectangle.height / 1000;
                }
                if (n12 == 1) {
                    n10 = rectangle.height - n10 * rectangle.height / 1000;
                }
                if (n11 != 0 && n12 != 0) {
                    n4 = n9 + dimension.height + n10;
                }
                if (n11 == 0) {
                    n9 = 0;
                }
                if (n12 == 0) {
                    n10 = 0;
                }
                n2 = n9 + dimension2.height + n10;
            }
            if (n > this.minWidth) {
                this.minWidth = n;
            }
            if (n3 > this.minWidth) {
                this.preferredWidth = n3;
            }
            if (n2 > this.minHeight) {
                this.minHeight = n2;
            }
            if (n4 <= this.preferredHeight) continue;
            this.preferredHeight = n4;
        }
    }

    public void layoutContainer(Container container) {
        this.container = container;
        Component[] componentArray = container.getComponents();
        Rectangle rectangle = container.getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component == null) continue;
            Object v = this.constraintMap.get(component);
            Rectangle rectangle2 = component.getBounds();
            Dimension dimension = component.getPreferredSize();
            if (dimension == null) {
                dimension = component.getSize();
            }
            if (!(v instanceof AnchorConstraint)) continue;
            AnchorConstraint anchorConstraint = (AnchorConstraint)v;
            int n3 = anchorConstraint.left;
            int n4 = anchorConstraint.right;
            int n5 = anchorConstraint.leftType;
            int n6 = anchorConstraint.rightType;
            if (n5 == 1) {
                n3 = n3 * n / 1000;
            }
            if (n6 == 1) {
                n4 = n - n4 * n / 1000;
            }
            if (n5 != 0) {
                if (n6 != 0) {
                    rectangle2.width = n - n4 - n3;
                    rectangle2.x = n3;
                } else {
                    rectangle2.width = dimension.width;
                    if (rectangle2.width + n3 > n) {
                        rectangle2.width = n - n3;
                    }
                    rectangle2.x = n3;
                }
            } else {
                if (n6 != 0) {
                    rectangle2.x = n - n4 - dimension.width;
                }
                rectangle2.width = dimension.width;
                if (rectangle2.width + rectangle2.x > n) {
                    rectangle2.width = n - rectangle2.x;
                }
            }
            int n7 = anchorConstraint.top;
            int n8 = anchorConstraint.bottom;
            int n9 = anchorConstraint.topType;
            int n10 = anchorConstraint.bottomType;
            if (n9 == 1) {
                n7 = n7 * n2 / 1000;
            }
            if (n10 == 1) {
                n8 = n2 - n8 * n2 / 1000;
            }
            if (n9 != 0) {
                if (n10 != 0) {
                    rectangle2.height = n2 - n8 - n7;
                    rectangle2.y = n7;
                } else {
                    rectangle2.height = dimension.height;
                    if (rectangle2.height + n7 > n2) {
                        rectangle2.height = n2 - n7;
                    }
                    rectangle2.y = n7;
                }
            } else {
                if (n10 != 0) {
                    rectangle2.y = n2 - n8 - dimension.height;
                }
                rectangle2.height = dimension.height;
                if (rectangle2.height + rectangle2.y > n2) {
                    rectangle2.height = n2 - rectangle2.y;
                }
            }
            component.setBounds(rectangle2);
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        this.constraintMap.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        this.initialize(container);
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }

    public Dimension minimumLayoutSize(Container container) {
        this.initialize(container);
        return new Dimension(this.minWidth, this.minHeight);
    }

    public void addLayoutComponent(Component component, Object object) {
        this.constraintMap.put(component, object);
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
        this.sizesCalculated = false;
    }
}

