% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers.R
\name{glance.irtree_fit}
\alias{glance.irtree_fit}
\title{Glance at an irtree_fit object}
\usage{
\method{glance}{irtree_fit}(x = NULL, ...)
}
\arguments{
\item{x}{object of class \code{irtree_fit} as returned from \code{\link[=fit.irtree_model]{fit()}}.}

\item{...}{Additional arguments. Not used.}
}
\value{
A one-row \link[tibble:tibble-package]{tibble} with columns such as \code{AIC} and \code{BIC}.
\subsection{Converged}{

The column \code{converged} indicates whether the model converged or not. For
Mplus, this is \code{TRUE} if the output contained the phrase "The model
estimation terminated normally". For mirt, this is equal to the output of
\code{\link[mirt:extract.mirt]{mirt::extract.mirt(x, "converged")}}. For TAM, this is
\code{NA} if no clear signs of non-convergence were observed. You are encouraged
to check any warnings or errors in any case.
}

\subsection{Iterations}{

\code{iterations} is \code{NA} for Mplus models since respective
information is not easily obtained from the output.
}
}
\description{
Glance accepts an \code{irtree_fit} object and returns a \link[tibble:tibble-package]{tibble}
with exactly one row of model summaries.
}
\examples{
data("jackson")
df1 <- jackson[1:234, paste0("C", 1:5)]
irtree_create_template(df1)
m1 <- "
IRT:
t BY C1@1, C2@1, C3@1, C4@1, C5@1;
Class:
GRM"
fit1 <- fit(irtree_model(m1), data = df1)

tidy(fit1, par_type = "difficulty")

glance(fit1)

augment(fit1)
}
\seealso{
\code{\link[generics:glance]{generics::glance()}}, \code{\link[mirt:extract.mirt]{mirt::extract.mirt(x, "secondordertest")}}
}
