% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling_dataset_issues.R
\name{format_issues}
\alias{format_issues}
\title{Format the issue in a simpler format}
\usage{
format_issues(
  raw_issues,
  raw_comments,
  repo = getOption("IssueTrackeR.repo"),
  owner = getOption("IssueTrackeR.owner"),
  verbose = TRUE
)
}
\arguments{
\item{raw_issues}{a \code{gh_response} object output from the function
\code{\link[gh]{gh}} which contains all the data and metadata for GitHub
issues.}

\item{raw_comments}{a \code{gh_response} object output from the function
\code{\link[gh]{gh}} which contains all the data and metadata for GitHub
comments.}

\item{repo}{A character string specifying the GitHub repository name (only
taken into account if \code{source} is set to \code{"online"}).
Defaults to the package option \code{IssueTrackeR.repo}.}

\item{owner}{A character string specifying the GitHub owner (only taken
into account if \code{source} is set to \code{"online"}).
Defaults to the package option \code{IssueTrackeR.owner}.}

\item{verbose}{A logical value indicating whether to print additional
information. Default is \code{TRUE}.}
}
\value{
a list representing an issue with simpler structure (with number,
title, body and labels) of all issues.
}
\description{
Format the issue in a simpler format
}
\examples{

\donttest{
raw_issues <- gh::gh(
    repo = "rjdemetra",
    owner = "rjdverse",
    endpoint = "/repos/:owner/:repo/issues",
    .limit = Inf
)
raw_comments <- gh::gh(
    repo = "rjdemetra",
    owner = "rjdverse",
    endpoint = "/repos/:owner/:repo/issues/comments",
    .limit = Inf
)
all_issues <- format_issues(raw_issues = raw_issues,
                            raw_comments = raw_comments,
                            verbose = FALSE)
}

}
