% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsoriX-datasets.R
\docType{data}
\name{CalibDataBat2}
\alias{CalibDataBat2}
\title{Calibration dataset for bat species}
\format{
A *dataframe* with 178 observations on 6 variables:
\tabular{rlll}{
[, 1] \tab site_ID \tab (*factor*) \tab Identification of the sampling site\cr
[, 2] \tab long \tab (*numeric*) \tab Longitude coordinate (decimal degrees)\cr
[, 3] \tab lat \tab (*numeric*) \tab Latitude coordinate (decimal degrees)\cr
[, 4] \tab elev \tab (*numeric*) \tab Elevation asl (m)\cr
[, 5] \tab sample_ID \tab (*factor*) \tab Identification of the sampled animal\cr
[, 6]  \tab sample_value \tab (*numeric*) \tab Hydrogen delta value of the tissue\cr }
}
\source{
data directly provided by the authors of the following publication
}
\description{
This dataset contains hydrogen delta values of fur keratin from sedentary
bat species captured between 2005 and 2009 from Popa-Lisseanu et al. (2012).
The data can be used as an example to fit a calibration model using the
function [calibfit].
}
\details{
Users who wish to use their own dataset for calibration should create a
*dataframe* of similar structure than this one (only the column
'species' can be dropped). The columns should possess the same names as the
ones described above. If the elevation is unknown at the sampling sites,
elevation information can be extracted from a high resolution elevation
raster using the function [terra::extract] (see **Examples**).
Note that the original study used a different source of elevation data.
}
\examples{

head(CalibDataBat2)
str(CalibDataBat2)

## The following example require to have downloaded
## an elevation raster with the function getelev()
## and will therefore not run unless you uncomment it

#if (require(terra)){
#    ## We delete the elevation data
#    CalibDataBat2$elev <- NULL
#
#    ## We reconstruct the elevation data using an elevation raster
#    getelev(file = "elevBats.tif", z = 6,
#            lat_min = min(CalibDataBat2$lat),
#            lat_max = max(CalibDataBat2$lat),
#            long_min = min(CalibDataBat2$long),
#            long_max = max(CalibDataBat2$long))
#    ElevationRasterBig <- rast("elevBats.tif")
#    CalibDataBat2$elev <- extract(
#        ElevationRasterBig,
#        cbind(CalibDataBat2$long, CalibDataBat2$lat))
#    head(CalibDataBat2)
#}

}
\references{
Popa-Lisseanu, A. G., Soergel, K., Luckner, A., Wassenaar, L.
I., Ibanez, C., Kramer-Schadt, S., Ciechanowski, M., Goerfoel, T., Niermann,
I., Beuneux, G., Myslajek, R. W., Juste, J., Fonderflick, J., Kelm, D.,
Voigt, C. C. (2012). A triple isotope approach to predict the breeding
origins of European bats. PLoS ONE 7(1):e30388.
}
\seealso{
[CalibDataBat] for another (related) calibration dataset

[calibfit] to fit a calibration model
}
\keyword{datasets}
