% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsoriX-datasets.R
\docType{data}
\name{AssignDataAlien}
\alias{AssignDataAlien}
\title{Simulated assignment dataset}
\format{
A *dataframe* with 10 observations on 2 variables:
\tabular{rlll}{
[, 1] \tab sample_ID \tab (*factor*) \tab Identification of the sample\cr
[, 2] \tab sample_value \tab (*numeric*) \tab Hydrogen delta value of the tissue\cr}
}
\description{
This dataset contains simulated hydrogen delta values. 
The data can be used as an example to perform assignments using the function [isofind].
}
\examples{

head(AssignDataAlien)
str(AssignDataAlien)

## The examples below will only be run if sufficient time is allowed
## You can change that by typing e.g. options_IsoriX(example_maxtime = XX)
## if you want to allow for examples taking up to ca. XX seconds to run
## (so don't write XX but put a number instead!)

if(getOption_IsoriX("example_maxtime") > 30) {

## The following describes how we created such dataset

### We prepare the precipitation data
GNIPDataDEagg <- prepsources(data = GNIPDataDE)

### We fit the models for Germany
GermanFit <- isofit(data = GNIPDataDEagg)

### We build the isoscape
GermanScape <- isoscape(raster = ElevRasterDE, isofit = GermanFit)

### We create a simulated dataset with 1 site and 10 observations
set.seed(1L)
Aliens <- create_aliens(calib_fn = list(intercept = 3, slope = 0.5, resid_var = 5),
                        isoscape = GermanScape,
                        raster = ElevRasterDE,
                        coordinates = data.frame(site_ID = "Berlin",
                                                 long   = 13.52134,
                                                 lat    = 52.50598),
                        n_sites = 1,
                        min_n_samples = 10,
                        max_n_samples = 10)
AssignDataAlien <- Aliens[, c("sample_ID", "sample_value")]

### Uncomment the following to store the file as we did
#save(AssignDataAlien, file = "AssignDataAlien.rda", compress = "xz")

}

}
\seealso{
[isofind] to perform assignments
}
\keyword{datasets}
