% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{join}
\alias{join}
\title{Get all overlapping tuples of intervals from multiple sets}
\usage{
join(..., output = "intervals")
}
\arguments{
\item{...}{Integer matrices of two columns, the first column giving the (inclusive) start points of intervals and the second column giving the corresponding (exclusive) end points.}

\item{output}{Character value, one of \code{"intervals"}, \code{"indices"} and \code{"sections"}.}
}
\value{
Integer matrix.
}
\description{
Get matrix specifying overlapping tuples of intervals from multiple sets. Each row specifies an overlapping tuple. The \code{n}th element in a row contains the row index of the interval in the \code{n}th set of intervals passed to the function. Depending on the value of the \code{output} argument, there may two additional columns giving the start and end coordinates of the overlap (the default: \code{output="intervals"}, no extra columns (\code{output="indices"}) or one additional column giving the row index of the 'section' of the complete set of intervals (\code{output="sections"}, see \code{\link{sections}}).
}
\examples{
join(rbind(c(1, 100), c(50, 100)), rbind(c(1, 2), c(49, 51), c(50, 200)))
}
