% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{DiffGenesSelection}
\alias{DiffGenesSelection}
\title{Differential expression for a selection of objects}
\usage{
DiffGenesSelection(List, Selection, geneExpr = NULL, nrclusters = NULL,
  method = "limma", sign = 0.05, topG = NULL, fusionsLog = TRUE,
  weightclust = TRUE, names = NULL)
}
\arguments{
\item{List}{A list of the clustering outputs to be compared. The first
element of the list will be used as the reference in
\code{ReorderToReference}.}

\item{Selection}{If differential gene expression should be investigated for
a specific selection of objects, this selection can be provided here.
Selection can be of the type "character" (names of the objects) or
"numeric" (the number of specific cluster). Default is NULL.}

\item{geneExpr}{The gene expression matrix or ExpressionSet of the objects.
The rows should correspond with the genes.}

\item{nrclusters}{Optional. The number of clusters to cut the dendrogram in.
The number of clusters should not be specified if the interest lies only in
a specific selection of objects which is known by name.  Otherwise, it is
required. Default is NULL.}

\item{method}{The method to applied to look for DE genes. For now, only the
limma method is available. Default is "limma".}

\item{sign}{The significance level to be handled. Default is 0.05.}

\item{topG}{Overrules sign. The number of top genes to be shown. Default is NULL.}

\item{fusionsLog}{Logical. To be handed to \code{ReorderToReference}: indicator for the fusion of clusters. Default is TRUE}

\item{weightclust}{Logical. To be handed to \code{ReorderToReference}: to be used for the outputs of CEC,
WeightedClust or WeightedSimClust. If TRUE, only the result of the Clust element is considered. Default is TRUE.}

\item{names}{Optional. Names of the methods. Default is NULL.}
}
\description{
Internal function of \code{DiffGenes}.
}
