% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{ColorsNames}
\alias{ColorsNames}
\title{Function that annotates colors to their names}
\usage{
ColorsNames(matrixColors, cols = NULL)
}
\arguments{
\item{matrixColors}{The output of the ReorderToReference function.}

\item{cols}{A character vector with the names of the colours to be used. Default is NULL.}
}
\value{
A matrix containing the hex code of the color that corresponds to
each cell of the matrix to be colored. This function is called upon by the
\code{ComparePlot} function.
}
\description{
The \code{ColorsNames} function is used on the output of the
\code{ReorderToReference} and matches the cluster numbers indicated by the
cell with the names of the colors.  This is necessary to produce the plot of
the \code{ComparePlot} function and is therefore an internal function of
this function but can also be applied separately.
}
\examples{

data(fingerprintMat)
data(targetMat)
data(Colors1)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)
MCF7_T = Cluster(targetMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55,StopRange=FALSE)

L=list(MCF7_F,MCF7_T)
names=c("FP","TP")

MatrixColors=ReorderToReference(List=L,nrclusters=7,fusionsLog=TRUE,weightclust=TRUE,
names=names)

Names=ColorsNames(matrixColors=MatrixColors,cols=Colors1)
}
