% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometric_aggregation.R
\name{geometric_aggregation}
\alias{geometric_aggregation}
\title{Geometric Aggregation}
\usage{
geometric_aggregation(
  data,
  weights = rep(1/ncol(data), ncol(data)),
  geo_wo = 0
)
}
\arguments{
\item{data}{dataframe with rows = observations and columns = quantitative}

\item{weights}{vector of weights (default all weights = 1/ ncol(dataframe))}

\item{geo_wo}{(geometric mean workaround to deal with negative values),
positive number to make all variables positive}
}
\value{
It returns a dataframe with rows = observations and column =
composite indicator
}
\description{
The purpose of the Geometric Aggregation function is to calculate a
synthetic index based on the geometric mean for a set of variables
}
\details{
This is simply the product of each indicator to the power of its weight, all
raised the the power of the inverse of the sum of the weights

The geometric mean is less compensatory than the arithmetic mean – low
values in one indicator only partially substitute high values in others. For
this reason, the geometric mean may sometimes be preferred when indicators
represent “essentials”. An example might be quality of life: a longer life
expectancy perhaps should not compensate severe restrictions on personal
freedoms
}
\examples{

data("Education")
Indicator=geometric_aggregation(Education)
print(Indicator)

#-----When there are negative values
set.seed(123)
Data=matrix(rnorm(100),nrow = 10,ncol = 10)
Indicator=geometric_aggregation(Data,geo_wo = 100)
print(Indicator)

}
\references{
OECD/European Union/EC-JRC (2008), Handbook on Constructing
Composite Indicators: Methodology and User Guide, OECD Publishing, Paris,
<https://doi.org/10.1787/9789264043466-en>
}
\keyword{Aggregation}
\keyword{Geometric}
