\name{DepNHNeyScot.fun}
\alias{DepNHNeyScot.fun}
\alias{GenSons.fun}

\title{Generates trajectories of dependent  Neyman-Scott cluster processes}

\description{ This function  generates dependent  (homogeneous or nonhomogeneous) point processes based on 
Neyman-Scott processes with the same trajectory of  cluster centers. 


It calls the auxiliary function \code{GenSons.fun} (not intended for the
     users), see Details section.
}


\usage{DepNHNeyScot.fun(lambdaParent, d, lambdaNumP = 1, dist = "normal", 
	sigmaC = 1, minC = -1, maxC = 1,fixed.seed=NULL)}


\arguments{
  \item{lambdaParent}{Numeric vector. Intensity values  of the  underlying PP used to generate 
the  centers of the clusters of the Neyman-Scott process.}
  \item{d}{Integer. Number of dependent processes to be generated.}
  \item{lambdaNumP}{Optional. Numeric vector. Mean values of the number of sons of each dependent process. If its length
	is equal to 1, the same value is used to generate all the dependent processes.}
  \item{dist}{Optional. Label "normal" or "uniform". Distribution  used to generate the  point locations of each 
	cluster.}
  \item{sigmaC}{Optional. Numeric vector.  Only used if dist="normal". Standard deviation of the normal distribution.   
	If its lengthis equal to 1, the same value is used in the \eqn{d} processes.}
  \item{minC}{Optional. Numeric  vector. Only used if dist="uniform". Lower limits of the  Uniform distribution.  If its length
	is equal to 1, the same value is used in the d processes.}
  \item{maxC}{Optional. Numeric  vector. Only used if dist="uniform". Upper limits of the  Uniform distribution. If its length
	is equal to 1, the same value is used in the \eqn{d} processes.}
  \item{fixed.seed}{Optional. An integer or NULL. Value used to set the seed 
	in random generation processes; if it is NULL, a random seed is used.}
}


\details{ A Neyman-Scott  process is a Poisson cluster process  where the points in each cluster are randomly
distributed around the cluster center.  

Dependent homogeneous or NH point processes,  in continuous time, are obtained by generating 
 Neyman-Scott processes with the same trajectory of  cluster centers.   First, the Poisson 
process of the cluster centers  is generated. Then, the number  of points in each cluster  
is generated using a Poisson distribution with  means which can be different in each process. 
The point  locations  around each center  can be generated using  two distributions N(0, sigmaC)  or Uniform(minC, maxC).  

 Remark that high values of sigmaC  or  the range maxC-minC lead to a high variability around the center and  to a 
low dependence between the  processes.
}



\value{
 A list with elements
  \item{posNH }{A list of  d vectors, containing the occurrence points of  the \eqn{d} dependent processes. The name of the 
	elements of the list are PP1, PP2...PPd}
}


\references{
Abaurrea, J. Asin, J. and Cebrian, A.C. (2014). A Bootstrap Test of Independence Between Three Temporal Nonhomogeneous Poisson Processes 
and its Application to Heat Wave Modeling. \emph{Environmental and Ecological Statistics}.

}


\seealso{\code{\link{IndNHNeyScot.fun}}, \code{\link{DepNHPPqueue.fun}}, \code{\link{DepMarkedNHPP.fun}}, \code{\link{DepNHCPSP.fun}}}

\examples{
# Generation of three dependent Neyman-Scott processes with  the same mean number
#of sons per cluster and locations generated by the same normal distribution

set.seed(123)
lambdaParent<-runif(100,0,0.1)

DepNHNeyScot.fun(lambdaParent=lambdaParent, d=3, lambdaNumP = 2,
	 dist = "normal", sigmaC = 3,fixed.seed=123)

}
