% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.IM4E.R
\name{pred.IM4E}
\alias{pred.IM4E}
\title{pred.IM4E}
\usage{
pred.IM4E(re, xx, yy, newx, sig = 1, type)
}
\arguments{
\item{re}{weight or result of IM4E algorithm}

\item{xx}{model matrix of explanatory variables}

\item{yy}{label vector}

\item{newx}{model matrix to be preded}

\item{sig}{sigma used in algorithm, default to be 1}

\item{type}{the form of final output}
}
\value{
\item{response}{preded probabilities for newx}

\item{class}{ preded class for newx}
}
\description{
This function performs the predion for IM4E(Iterative Margin-Maximization under Max-Min Entropy) algorithm.
}
\examples{
data(park)
xx<-park$xx
yy<-park$yy
index<-c(1:floor(nrow(xx)*0.3))
train_xx<-xx[-index,]
test_xx<-xx[index,]
train_yy<-yy[-index]
test_yy<-yy[index]
re<-IM4E(train_xx,train_yy)
pred.res<-pred.IM4E(re,train_xx,train_yy,test_xx,type="class")
print(pred.res)

}
\keyword{IM4E}
\keyword{pred}
