% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{RunMCMC}
\alias{RunMCMC}
\title{Run MCMC to Fit Contour Model}
\usage{
RunMCMC(n_iter, dists, x, xU_vecs, xU_years, xU_prop_sd, xU_lb, xU_ub, mu,
  mu0, lambda0, sigma, sigma_ind_1, sigma_ind_2, sigma_prop_cov, rho,
  rho0_lb, rho0_ub, rho_prop_sd, sigma0_lb, sigma0_ub, w)
}
\arguments{
\item{n_iter}{number of iterations to run the MCMC}

\item{dists}{symmetric matrix of the same dimension as the number of
lines being used, specifying distances among starting locations
or angles.}

\item{x}{a matrix of observed distances (y) of dimension number
of vectors by number of years}

\item{xU_vecs}{vector giving the indices of each x value vector in each year
that is not observed (vector indices and year indices are
paired, so must be ordered the same as xU_years)}

\item{xU_years}{vector giving the indices of each year in which each x value
vector is not observed (vector indices and year indices are
paired, so must be ordered the same as xU_vecs)}

\item{xU_prop_sd}{Standard deviation for proposals for xU}

\item{xU_lb}{Lower bounds for xU values being sampled (order must match
orded of xU_vecs and xU_years)}

\item{xU_ub}{Upper bounds for xU values being sampled (order must match
orded of xU_vecs and xU_years)}

\item{mu}{vector of the same length as the number of lines which specifies
the values from which each element of \code{mu} will be initialized
in the MCMC.}

\item{mu0}{vector of the same length as the number of lines which specifies
the prior mean for \code{mu}.}

\item{lambda0}{matrix of the same dimension as the number of lines which
specifices the prior covariance matrix for \code{mu}.}

\item{sigma}{vector of the same length as the number of lines which
specifies the values from which each element in \code{sigma}
will be initialized from}

\item{sigma_ind_1}{vector giving the first index of each section of sigma's
to be sampled together}

\item{sigma_ind_2}{vector giving the last index of each section of sigma's
to be sampled together}

\item{sigma_prop_cov}{covariance matrix of the same length as the number of
lines that is used in sampling \code{sigma} values}

\item{rho}{double between 0 and 1 from which the value of \code{rho} will
be initialized}

\item{rho0_lb}{double between 0 and 1 which gives the lower bound of the
uniform prior for \code{rho}}

\item{rho0_ub}{double between 0 and 1 which gives the upper bound of the
uniform prior for \code{rho}.}

\item{rho_prop_sd}{standard deviation for the normal proposal distribution used
when proposing value for \code{rho} in the sampler. Defaults
to 0.01}

\item{sigma0_lb}{vector of the same length as the number of lines which
specifies the lower bound of the uniform prior for each
sigma value}

\item{sigma0_ub}{vector of the same length as the number of lines which
specifies the upper bound of the uniform prior for each sigma
value.}

\item{w}{Integer specifying how many samples of the parameters will be
maintained. Samples from every wth iteration is stored.}
}
\value{
List of length 7 that gives the values of the MCMC chain for
        \code{xU}, \code{mu}, \code{sigma} and \code{rho} along with
        indicators of acceptance on each iteration: \code{xURate},
        \code{sigmaRate}, and \code{rhoRate}.
}
\description{
Run MCMC to Fit Contour Model
}
