% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selfIntersections.R
\name{untwist}
\alias{untwist}
\title{Remove self-intersections}
\usage{
untwist(myPoly, plotting = FALSE, polyName = "unspecified")
}
\arguments{
\item{myPoly}{\code{SpatialPolygons} object from which self-intersections need to be removed}

\item{plotting}{boolean indicating if results should be plotted}

\item{polyName}{name for \code{SpatialPolygons} object to return (defaults to "unspecified")}
}
\value{
\code{SpatialPolygons} object with self-intersections removed
}
\description{
Function to remove all self-intersections from a contour.
}
\examples{
\dontrun{
par(mfrow = c(1, 2))
plot(interEx, main = "Original Contour")
noInter <- untwist(interEx, polyName = "interEx")
plot(noInter, main = "Final Contour")
}
}
