% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_IVDML.R
\name{robust_p_value_aggregated}
\alias{robust_p_value_aggregated}
\title{Compute Aggregated Robust p-Value for Treatment Effect in an IVDML Object}
\usage{
robust_p_value_aggregated(
  object,
  candidate_value,
  iv_method,
  a = NULL,
  A = NULL,
  kernel_name = NULL,
  bandwidth = NULL,
  agg_method = "DML_agg",
  gamma = 0.5
)
}
\arguments{
\item{object}{An object of class \code{IVDML}, produced by the \code{\link[=fit_IVDML]{fit_IVDML()}} function.}

\item{candidate_value}{Numeric. The candidate treatment effect value to test.}

\item{iv_method}{Character. The instrumental variable estimation method to use. Must be one of the methods specified in the fitted object.}

\item{a}{Numeric (optional). A specific value of \code{A} at which to compute the p-value for the heterogeneous treatment effect. If \code{NULL}, the function returns the p-value for the homogeneous treatment effect.}

\item{A}{Numeric vector (optional). The variable with respect to which treatment effect heterogeneity is considered. If \code{NULL}, the function assumes the \code{A} used in model fitting.}

\item{kernel_name}{Character (optional). The name of the kernel function to use for smoothing (if a heterogeneous treatment effect is estimated). Must be one of "boxcar", "gaussian", "epanechnikov", or "tricube".}

\item{bandwidth}{Numeric (optional). The bandwidth for the kernel smoothing (if a heterogeneous treatment effect is estimated).}

\item{agg_method}{Character (default: "DML_agg"). The aggregation method for computing the p-value. Options are:
\itemize{
\item \code{"DML_agg"}: Uses the Double Machine Learning (DML) aggregation approach.
\item \code{"MMB_agg"}: Uses the quantile-based aggregation method of Meinshausen, Meier, and Bühlmann (2009).
}}

\item{gamma}{Numeric (default: 0.5). Quantile level for the \code{"MMB_agg"} method. Ignored if \code{agg_method = "DML_agg"}.}
}
\value{
The aggregated robust p-value for testing the candidate treatment effect.
}
\description{
This function calculates an aggregated robust (with respect to weak IV) p-value for testing a candidate treatment effect value in a fitted \code{IVDML} object (output of \code{\link[=fit_IVDML]{fit_IVDML()}}), using either the the standard Double Machine Learning aggregation method ("DML_agg") or the method by Meinshausen, Meier, and Bühlmann (2009) ("MMB_agg") to aggregate the p-values corresponding to the \code{S_split} cross-fitting sample splits (where \code{S_split} was an argument of the \code{\link[=fit_IVDML]{fit_IVDML()}} function).
}
\examples{
set.seed(1)
Z <- rnorm(100)
X <- Z + rnorm(100)
H <- rnorm(100)
D <- Z^2 + sin(X) + H + rnorm(100)
A <- X
Y <- tanh(A) * D + cos(X) - H + rnorm(100)
fit <- fit_IVDML(Y = Y, D = D, Z = Z, X = X, A = A, ml_method = "gam")
robust_p_value_aggregated(fit, candidate_value = 0, iv_method = "mlIV")
robust_p_value_aggregated(fit, candidate_value = 0, iv_method = "mlIV",
                          a = 0, A = A, kernel_name = "boxcar", bandwidth = 0.2)

}
\references{
Meinshausen, N., Meier, L., & Bühlmann, P. (2009). \emph{P-values for high-dimensional regression}. Journal of the American Statistical Association, 104(488), 1671–1681.
}
