% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratory.R
\name{phi}
\alias{phi}
\title{Phi coefficient of correlation}
\usage{
phi(x)
}
\arguments{
\item{x}{a 1 x 4 vector or a matrix 2 x 2 of frequencies.}
}
\value{
the value of the phi coefficient correlation.
}
\description{
The phi coefficient of is  a correlation coefficient applied 
to dichotomous data. Given a two x two table of counts
| a | b | R1 |
| c | d | R1 |
|---|---|----|
|C1 | C2| n  |
or a vector c(a,b,c,d) of frequencies.
}
\details{
The coefficient phi is calculated from \deqn{(ad - bc)/\sqrt{p_qp_2q_1q_2}}
where $p_i$ and $q_i$ are the ratios of the dichotomous variables.
}
\examples{
#x2 <- matrix(x,ncol=2)
#phi(x2)
}
\references{
Warrens, Matthijs (2008), On Association Coefficients for 2x2 Tables and Properties That Do Not Depend on the Marginal Distributions. Psychometrika, 73, 777-789.

Yule, G.U. (1912). On the methods of measuring the association between two attributes. Journal of the Royal Statistical Society, 75, 579-652.
}

