% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.stopping.R
\name{check.stopping}
\alias{check.stopping}
\title{(Internal function) Check whether the IPCAPS process meets the stopping
criterion.}
\usage{
check.stopping(eigen.value, threshold)
}
\arguments{
\item{eigen.value}{A vector of Eigenvalues return from \code{svd} ($d),
\code{rARPACK::svds} ($d),  \code{eigen} ($values) or \code{rARPACK::eigs} ($values).}

\item{threshold}{A threshold or a cutoff to stop the IPCAPS process. Also see
\code{\link{ipcaps}} (the parameter \code{threshold}).}
}
\value{
A list containing \code{status}, \code{eigen.value}, \code{eigen.fit},
\code{threshold}, and \code{no.significant.PC} as explained below:
\itemize{
\item \code{$status} is either \code{0} representing that the criterion is
not met, or \code{1} representing that the criterion is met.
\item \code{$eigen.value} is a vector of Eigenvalues as the input parameter.
\item \code{$eigen.fit} is a vector of EigenFit values.
\item \code{$threshold} is a threashold as the input parameter.
\item \code{$no.significant.PC} is an estimated number of sinificant
principal components (PC).
}
}
\description{
(Internal function) Check whether the IPCAPS process meets the stopping
criterion.
}
