% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{pairwise.test}
\alias{pairwise.test}
\alias{pairwise.test.list}
\alias{pairwise.test.DataSetList}
\title{Performs a pairwise Kolmogorov-Smirnov test on the bootstrapped running times
among a data set}
\usage{
pairwise.test(x, ...)

\method{pairwise.test}{list}(x, max_eval, bootstrap.size = 30, ...)

\method{pairwise.test}{DataSetList}(x, ftarget, bootstrap.size = 0,
  which = "by_FV", ...)
}
\arguments{
\item{x}{either a list that contains running time sample for each algorithm as
sub-lists, or a DataSetList object}

\item{...}{all other options}

\item{max_eval}{list that contains the maximal running time for each algorithm
as sub-lists}

\item{bootstrap.size}{integer, the size of the bootstrapped sample. Set to 0 to disable bootstrapping}

\item{ftarget}{float, the target value used to determine the running / hitting}

\item{which}{wheter to do fixed-target ('by_FV') or fixed-budget ('by_RT') comparison
time}
}
\value{
A matrix containing p-values of the test
}
\description{
This function performs a Kolmogorov-Smirnov test on each pair of
algorithms in the input x to determine which algorithm gives a significantly
smaller running time. The resulting p-values are arranged in a matrix, where
each cell (i, j) contains a p-value from the test with alternative hypothesis:
the running time of algorithm i is smaller (thus better) than that of j.
}
\examples{
pairwise.test(subset(dsl, funcId == 1), 16)
}
