% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_models.R
\name{merge_models}
\alias{merge_models}
\title{Merging two model output tibbles.}
\usage{
merge_models(mod_tbl1, mod_tbl2)
}
\arguments{
\item{mod_tbl1}{Model output tibble created e.g. with \code{\link{model_gam}}.}

\item{mod_tbl2}{Model output tibble created e.g. with \code{\link{select_model}}.}
}
\value{
\code{merge_models} returns the same type as the input including all columns of
both tibbles.
}
\description{
The function appends the second model output tibble to the first
while keeping all variables from both tibbles.
}
\details{
\code{merge_models} function applies internally the dplyr::bind_rows function so that columns
are matched by name, and any missing columns will be filled with NA. The function
has also some data validation incorporated to check for double entries.
}
\examples{
# Using some models of the Baltic Sea demo data:
# Merging GAM and GAMM tibbles
test_ids <- 47:50 # choose subset
gam_tbl <- model_gam_ex[test_ids,]
gamm_tbl <- model_gamm(ind_init_ex[test_ids,], filter= gam_tbl$tac)
best_gamm <- select_model(gam_tbl, gamm_tbl)
merge_models(gam_tbl[gam_tbl$tac == FALSE,], best_gamm)

# Merge 2 IND-specific GAM tibbles (where)
dat_init <- ind_init(
  ind_tbl = ind_ex[, c("TZA", "Cod")],
  press_tbl = press_ex[, c("Tsum", "Swin")],
  time = ind_ex[,1])
gam_tbl1 <- model_gam(dat_init[1:2, ])
# treat a subset differently, e.g. when setting k
gam_tbl2 <- model_gam(dat_init[3:4, ], k = 3)
merge_models(gam_tbl1, gam_tbl2)
}
