% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{USPSdigits}
\alias{USPSdigits}
\title{USPS handwritten digits}
\format{A list of length 2 with the following elements, each one a \code{data.frame}:
\describe{
\item{\code{train}}{The training set of 7,291 digits.}
\item{\code{test}}{The test set of 2,007 digits.}}
Each \code{data.frame} contains the known digit labels in its first column.

The remaining 256 columns give the concatenation of the 16x16 grid.

Pixels are scaled such that [-1,1] corresponds to [white,black].}
\usage{
data(USPSdigits)
}
\description{
Training and test sets for the United States Postal Service (USPS) handwritten digits data, with 8-bit 16x16 grayscale grid representations of image scans of the digits "0" through "9".
}
\examples{
# Load the data and record the labels
data(USPSdigits)
ylab  <- USPSdigits$train[,1]
train <- USPSdigits$train[,-1]

# Examine the effect of discarding peripheral pixels
SDs   <- apply(train, 2, sd)
ind   <- SDs > 0.7
dat   <- train[,ind]

hist(SDs, breaks=200, xlim=c(0, 1))
rect(0.7, 0, 1, 12, col=2, density=25)

show_digit(ind) # retained pixels are shown in black
}
\references{
Hastie, T., Tibshirani, R., and Friedman, J. (2001). \emph{The Elements of Statistical Learning}. Springer Series in Statistics. New York, NY, USA: Spring New York Inc., \ifelse{html}{\out{2<sup>nd</sup>}}{\eqn{2\textsuperscript{nd}}} edition.
}
\seealso{
\code{\link{show_digit}}, \code{\link{show_IMIFA_digit}}
}
\keyword{datasets}
