% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAborted.R
\name{getAborted}
\alias{getAborted}
\title{Aborted Batch Files Retrieval}
\usage{
getAborted(aborted, default_batch_dir, config_file)
}
\arguments{
\item{aborted}{path to file containing aborted information.\cr
If missing, the default, a dialog box will be displayed to choose this file.
Note, that if provided 'default_batch_dir' and 'config_file' will not be used.}

\item{default_batch_dir}{directory where batches are stored.\cr
It can be found in IDEAS(R) software, under Options -> Application Defaults -> Directories -> Default Batch Report Files Directory.
If missing, the default, it will be deduced from IDEAS(R) config file, However, if it can't be deduced then current working directory will be used.\cr
This argument takes precedence over 'config_file' and filling 'default_batch_dir' prevents the use of 'config_file' argument.}

\item{config_file}{path to IDEAS(R) config file.\cr
It may depends on IDEAS(R) software installation but one may use "C:/Users/\%USER\%/AppData/Roaming/Amnis Corporation/userconfig.xml".}
}
\value{
a list of 3 elements:\cr
-not_existing: a list of files paths that caused failure because they were not found during batch,\cr
-failed_found: a list of failed files and their unique corresponding paths,\cr
-failed_match: a list of failed files and their all paths that could match.
}
\description{
Try to retrieve files whose processing failed during batch. This is a very beta version
}
