% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeIFC.R
\name{writeIFC}
\alias{writeIFC}
\title{IFC Files Generic Writer}
\usage{
writeIFC(fileName, ...)
}
\arguments{
\item{fileName}{path to file.}

\item{...}{arguments to pass to \code{\link{ExportToDAF}} or \code{\link{ExportToXIF}}.}
}
\value{
it invisible returns the path of exported file.
}
\description{
Writes IFC data to DAF and subsets or merges RIF/CIF Files.
}
\details{
If 'fileName' is a DAF file \code{\link{ExportToDAF}} will be used to write file whereas if it is a RIF or CIF file \code{\link{writeIFC}} will use \code{\link{ExportToXIF}}.
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  tmp <- tempdir(check = TRUE)
  ## use a daf file
  file_daf <- system.file("extdata", "example.daf", package = "IFCdata")
  ## create a tagged population named test with 1st object
  pop <- buildPopulation(name = "test", type = "T", obj = 0)
  writeIFC(file_daf, write_to = paste0(tmp, "\\\\test_write.daf"),
           overwrite = TRUE, pops = list(pop))
  ## use a rif file, but you can also use a cif
  file_rif <- system.file("extdata", "example.rif", package = "IFCdata")
  writeIFC(fileName = file_rif, write_to = paste0(tmp, "\\\\test_write.rif"), 
           overwrite = TRUE, objects = 0)
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
