% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.theta.typed.permute}
\alias{get.theta.typed.permute}
\title{get the null distribution of the get.theta.typed function}
\usage{
get.theta.typed.permute(posmat, typeA = -1, typeB = -1, r = 1,
  r.low = rep(0, length(r)), permutations)
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{typeA}{the "from" type that we are interested in, -1 is wildcard}

\item{typeB}{the "to" type that we are interested i, -1 is wildcard}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{permutations}{the number of permute iterations}
}
\value{
theta values for all the distances we looked at
}
\description{
Does permutations to calculate the null distribution of get theta
if there were no spatial dependence. Randomly reassigns coordinates
to each observation permutations times
}
\examples{
\dontrun{
 R/examples/get_theta_typed_permute.R
 }

}
\seealso{
Other get.theta: \code{\link{get.theta.bootstrap}},
  \code{\link{get.theta.ci}},
  \code{\link{get.theta.permute}},
  \code{\link{get.theta.typed.bootstrap}},
  \code{\link{get.theta.typed}}, \code{\link{get.theta}}
}
\author{
Justin Lessler and Henrik Salje
}
