% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigratio.R
\name{sigratio}
\alias{sigratio}
\title{Ratio of significantly different zones.}
\usage{
sigratio(formula, data, ndisc, methoddisc, methodoverlay = "fuzzyAND")
}
\arguments{
\item{formula}{A formula of spatial variables}

\item{data}{A data frame of dataset}

\item{ndisc}{A numeric vector of break numbers for respective
explanatory variables}

\item{methoddisc}{A character vector of discretization methods}

\item{methodoverlay}{A character of spatial overlay methods, including
"fuzzyAND" and "intersection"}
}
\value{
A list of ratios of significantly different zones.
}
\description{
Ratio of significantly different zones.
}
\examples{
sr1 <- sigratio(formula = y ~ xa + xb + xc, data = sim,
               ndisc = c(4,4,5), methoddisc = "quantile",
               methodoverlay = "fuzzyAND")
sr2 <- sigratio(formula = y ~ xa + xb + xc, data = sim,
               ndisc = c(4,4,5), methoddisc = "quantile",
               methodoverlay = "intersection")
sr1$n.zone; sr2$n.zone
sr1$ratio.sigdif; sr2$ratio.sigdif

}
