% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectaddavar.R
\name{selectaddavar}
\alias{selectaddavar}
\title{Selecting and adding a variable to improve PID.}
\usage{
selectaddavar(y, x, xh, location, x.given, x.option,
                     method = "fuzzyAND")
}
\arguments{
\item{y}{A numeric vector of a response variable}

\item{x}{A data frame or a matrix of explanatory variables}

\item{xh}{A data frame or a matrix of discretized explanatory variables}

\item{location}{A data frame of locations}

\item{x.given}{A name of a start variable}

\item{x.option}{A character vector of names of optional variables}

\item{method}{A character of spatial overlay method}
}
\value{
A list of process data of improving PID values by adding a variable.
}
\description{
Selecting and adding a variable to improve PID.
}
\examples{
library(GD)
x <- sim[, 4:6]
x.disc <- apply(x, 2, FUN = function(u) disc(u, 4, "quantile"))
xh <- do.call(cbind, lapply(1:ncol(x), function(u)
  data.frame(cut(x[, u], x.disc[[u]]$itv, include.lowest = TRUE))))
names(xh) <- names(x)
sav <- selectaddavar(y = sim[, 1], x = x, xh = xh,
                     location = sim[, c("lo","la")],
                     x.given = "xc", x.option = c("xa", "xb"),
                     method = "fuzzyAND")
}
