% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDF.R
\name{IDF.read}
\alias{IDF.read}
\title{Reading precipitation data}
\usage{
IDF.read(file, type)
}
\arguments{
\item{file}{a \code{character string} naming the file from which the data is to be read.}

\item{type}{a \code{character string} defining the type of data to be read: either "stadtmessnetz" or "webwerdis", depending on if the data comes from the Stadtmessnetz Berlin
or WebWerdis. If type = "webwerdis", the data will be read, then sorted, formatted and missing lines added, 
while if type = "stadtmessnetz", the data will just be read and formatted. 
Both source types have a different layout in the original file.}
}
\value{
Liste a \code{data.frame} of date and time information and precipitation values for each time step
}
\description{
The function \code{IDF.read} reads a file in table format and creates a \code{data.frame} from it
and adds some attributes (station information, aggregation time, data source). The only data values used are: 
date, precipitation
The \code{data.frame} will have the following format:
| year | mon | day | hour | min | RR |
|------+-----+-----+------+-----+----+
|      |     |     |      |     |    |
}
\details{
This function is designed to prepare a data file for doing an estimation on IDF parameters in function \code{IDF.fit}.
The time given in the data is the end time, so the precipitation was measured up to that time.
}
\author{
Sarah Joedicke \email{sarah.joedicke@fu-berlin.de}

Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}
\seealso{
read.table, IDF.fit
}

