% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_2par_exp_censor2}
\alias{FIM_2par_exp_censor2}
\title{Fisher Information Matrix for a 2-Parameter Cox Proportional-Hazards Model for Random Censored Data}
\usage{
FIM_2par_exp_censor2(x, w, param, tcensor)
}
\arguments{
\item{x}{Vector of design points.}

\item{w}{Vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w) = 1}.}

\item{param}{Vector of values for the model parameters \eqn{c(\beta_0, \beta_1)}.}

\item{tcensor}{The experiment is terminated at the fixed time point \code{tcensor}.}
}
\value{
Fisher information matrix.
}
\description{
It provides the cpp function for the FIM introduced in  Eq. (3.1) of Schmidt and Schwabe (2015) for random censored data (type two censored data).
}
\references{
Schmidt, D., & Schwabe, R. (2015). On optimal designs for censored data. Metrika, 78(3), 237-257.
}
