% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{StrelkaIDVCFFilesToCatalog}
\alias{StrelkaIDVCFFilesToCatalog}
\title{Create ID (indel) catalog from Strelka ID VCF files}
\usage{
StrelkaIDVCFFilesToCatalog(files, ref.genome, region = "unknown")
}
\arguments{
\item{files}{Character vector of file paths to the Strelka ID VCF files.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{region}{A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}
}
\value{
An ID (indel) catalog with attributes added. See
  \code{\link{as.catalog}} for more details.
}
\description{
Create ID (indel) catalog from the Strelka ID VCFs specified by \code{files}
}
\details{
This function calls \code{\link{VCFsToIDCatalogs}}
}
\note{
In ID (insertion and deletion) catalogs, deletion repeat sizes
  range from 0 to 5+, but for plotting and end-user documentation
  deletion repeat sizes range from 1 to 6+.
}
\examples{
file <- c(system.file("extdata",
                      "Strelka.ID.GRCh37.vcf",
                      package = "ICAMS"))
catID <- StrelkaIDVCFFilesToCatalog(file, ref.genome = "hg19", 
                                          region = "genome")
}
