% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypergeomPFQ.R
\name{hypergeomPFQ}
\alias{hypergeomPFQ}
\title{Hypergeometric function of a matrix argument}
\usage{
hypergeomPFQ(m, a, b, x, alpha = 2)
}
\arguments{
\item{m}{truncation weight of the summation, a positive integer}

\item{a}{the "upper" parameters, a numeric or complex vector,
possibly empty (or \code{NULL})}

\item{b}{the "lower" parameters, a numeric or complex vector,
possibly empty (or \code{NULL})}

\item{x}{either a real or complex square matrix,
or a numeric or complex vector, the eigenvalues of the matrix}

\item{alpha}{the alpha parameter, a positive number}
}
\value{
A real or a complex number.
}
\description{
Evaluates a truncated hypergeometric function of a matrix
argument.
}
\details{
This is an implementation of Koev & Edelman's algorithm
(see the reference). This algorithm is split into two parts: the case of
a scalar matrix (multiple of an identity matrix) and the general case.
The case of a scalar matrix is much faster (try e.g. \code{x = c(1,1,1)} vs
\code{x = c(1,1,0.999)}).
}
\note{
The hypergeometric function of a matrix argument is usually defined
for a symmetric real matrix or a Hermitian complex matrix.
}
\examples{
# a scalar x example, the Gauss hypergeometric function
hypergeomPFQ(m = 10, a = c(1,2), b = c(3), x = 0.2)
gsl::hyperg_2F1(1, 2, 3, 0.2)
# 0F0 is the exponential of the trace
X <- toeplitz(c(3,2,1))/10
hypergeomPFQ(m = 10, a = NULL, b = NULL, x = X)
exp(sum(diag(X)))
# 1F0 is det(I-X)^(-a)
X <- toeplitz(c(3,2,1))/100
hypergeomPFQ(m = 10, a = 3, b = NULL, x = X)
det(diag(3)-X)^(-3)
# Herz's relation for 1F1
hypergeomPFQ(m = 10, a = 2, b = 3, x = X)
exp(sum(diag(X))) * hypergeomPFQ(m = 10, a = 3-2, b = 3, x = -X)
# Herz's relation for 2F1
hypergeomPFQ(10, a = c(1,2), b = 3, x = X)
det(diag(3)-X)^(-2) *
  hypergeomPFQ(10, a = c(3-1,2), b = 3, -X \%*\% solve(diag(3)-X))
}
\references{
Plamen Koev and Alan Edelman.
\emph{The Efficient Evaluation of the Hypergeometric Function of a Matrix Argument}.
Mathematics of Computation, 75, 833-846, 2006.
}
