% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.HydeNetwork.R
\name{update.HydeNetwork}
\alias{update.HydeNetwork}
\title{Update Probabilistic Graphical Network}
\usage{
\method{update}{HydeNetwork}(object, formula, ...)
}
\arguments{
\item{object}{A \code{HydeNetwork} object}

\item{formula}{A formula statement indicating the changes to the network.}

\item{...}{Additional arguments to be passed to other methods.  Current,
none are used.}
}
\description{
Add or remove nodes or add parents within a \code{HydeNetwork}
  model.
}
\details{
Adding or removing nodes is fairly straightforward if you are 
  removing a complete node (along with its parents).  Removing a parent
  will generate a warning that the child nodes may need to be redefined.
}
\examples{
data(PE, package="HydeNet")
Net <- HydeNetwork(~ wells + 
                     pe | wells + 
                     d.dimer | pregnant*pe + 
                     angio | pe + 
                     treat | d.dimer*angio + 
                     death | pe*treat)
                     
plot(Net)

Net <- update(Net, . ~ . - pregnant)
plot(Net)
 
}
\author{
Jarrod Dalton and Benjamin Nutter
}
