% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_logistic_regression.R
\name{calc_logistic_regression}
\alias{calc_logistic_regression}
\title{Calculate logistic regression in annual statistics with zero values}
\usage{
calc_logistic_regression(data = NULL, year, value, ...)
}
\arguments{
\item{data}{'data.frame'. Optional data.frame input, with columns containing \code{year} and \code{value}.
Column names are specified as strings in the corresponding parameter. Default is \code{NULL}.}

\item{year}{'numeric' vector when \code{data = NULL}, or 'character' string identifying year column
name when \code{data} is specified. Year of each value in \code{value} parameter.}

\item{value}{'numeric' vector when \code{data = NULL}, or 'character' string identifying value column
name when \code{data} is specified. Values to calculate logistic regression on.}

\item{...}{further arguments to be passed to or from \code{\link[stats:glm]{stats::glm}}.}
}
\value{
A tibble (see \code{\link[tibble:tibble]{tibble::tibble}}) with logistic regression p-value, standard error of
slope, odds ratio, beginning and ending probability, and probability change. See \strong{Details}.
}
\description{
Calculate logistic regression (Everitt and Hothorn, 2009) in annual statistics with
zero values. A model fit to compute the probability of a zero flow annual statistic.
}
\details{
This function is a wrapper for \verb{stats::glm(y ~ year, family = stats::binomial(link="logit")}
with \code{y = 1} when \code{value = 0} (for example a zero flow annual statistic) and \code{y = 0} otherwise.
The returned values include
\describe{
\item{\code{p_value}}{Probability value of the explanatory (\code{year}) variable in the logistic model}
\item{\code{stdErr_slope}}{Standard error of the regression slope (log odds per year)}
\item{\code{odds_ratio}}{Exponential of the explanatory coefficient (year coefficient)}
\item{\code{prob_beg/end}}{Logistic regression predicted (fitted) values at the beginning and ending year.}
\item{\code{prob_change}}{Change in probability from beginning to end.}
}
Example, an odds ratio of 1.05 represents the odds of a zero-flow year (versus non-zero)
increase by a factor of 1.05 (or 5 percent).
}
\examples{
calc_logistic_regression(data = example_annual, year = "WY", value = "annual_mean")

}
\references{
Everitt, B. S. and Hothorn T., 2009, A Handbook of Statistical Analyses Using R, 2nd Ed.
Boca Raton, Florida, Chapman and Hall/CRC, 376p.
}
\seealso{
\code{\link[stats]{glm}}
}
\keyword{annual-statistics}
\keyword{trends}
